/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ViewPropertyAnimator {
    private final View mView;
    private long mDuration;
    private boolean mDurationSet = false;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private TimeInterpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private static final int NONE = 0;
    private static final int TRANSLATION_X = 1;
    private static final int TRANSLATION_Y = 2;
    private static final int SCALE_X = 4;
    private static final int SCALE_Y = 8;
    private static final int ROTATION = 16;
    private static final int ROTATION_X = 32;
    private static final int ROTATION_Y = 64;
    private static final int X = 128;
    private static final int Y = 256;
    private static final int ALPHA = 512;
    private static final int TRANSFORM_MASK = 511;
    private Runnable mAnimationStarter = new Runnable(){

        public void run() {
            ViewPropertyAnimator.this.startAnimation();
        }
    };
    private HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();

    ViewPropertyAnimator(View view) {
        this.mView = view;
        view.ensureTransformationInfo();
    }

    public ViewPropertyAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDurationSet = true;
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        return new ValueAnimator().getDuration();
    }

    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    public ViewPropertyAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + startDelay);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = startDelay;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator2;
        return this;
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    public void start() {
        this.startAnimation();
    }

    public void cancel() {
        if (this.mAnimatorMap.size() > 0) {
            HashMap mAnimatorMapCopy = (HashMap)this.mAnimatorMap.clone();
            Set animatorSet = mAnimatorMapCopy.keySet();
            for (Animator runningAnim : animatorSet) {
                runningAnim.cancel();
            }
        }
        this.mPendingAnimations.clear();
        this.mView.removeCallbacks(this.mAnimationStarter);
    }

    public ViewPropertyAnimator x(float value) {
        this.animateProperty(128, value);
        return this;
    }

    public ViewPropertyAnimator xBy(float value) {
        this.animatePropertyBy(128, value);
        return this;
    }

    public ViewPropertyAnimator y(float value) {
        this.animateProperty(256, value);
        return this;
    }

    public ViewPropertyAnimator yBy(float value) {
        this.animatePropertyBy(256, value);
        return this;
    }

    public ViewPropertyAnimator rotation(float value) {
        this.animateProperty(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float value) {
        this.animatePropertyBy(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationX(float value) {
        this.animateProperty(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float value) {
        this.animatePropertyBy(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationY(float value) {
        this.animateProperty(64, value);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float value) {
        this.animatePropertyBy(64, value);
        return this;
    }

    public ViewPropertyAnimator translationX(float value) {
        this.animateProperty(1, value);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float value) {
        this.animatePropertyBy(1, value);
        return this;
    }

    public ViewPropertyAnimator translationY(float value) {
        this.animateProperty(2, value);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float value) {
        this.animatePropertyBy(2, value);
        return this;
    }

    public ViewPropertyAnimator scaleX(float value) {
        this.animateProperty(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float value) {
        this.animatePropertyBy(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleY(float value) {
        this.animateProperty(8, value);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float value) {
        this.animatePropertyBy(8, value);
        return this;
    }

    public ViewPropertyAnimator alpha(float value) {
        this.animateProperty(512, value);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float value) {
        this.animatePropertyBy(512, value);
        return this;
    }

    private void startAnimation() {
        ValueAnimator animator2 = ValueAnimator.ofFloat(1.0f);
        ArrayList nameValueList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int propertyMask = 0;
        int propertyCount = nameValueList.size();
        for (int i = 0; i < propertyCount; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)nameValueList.get(i);
            propertyMask |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(animator2, new PropertyBundle(propertyMask, nameValueList));
        animator2.addUpdateListener(this.mAnimatorEventListener);
        animator2.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            animator2.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            animator2.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            animator2.setInterpolator(this.mInterpolator);
        }
        animator2.start();
    }

    private void animateProperty(int constantName, float toValue) {
        float fromValue = this.getValue(constantName);
        float deltaValue = toValue - fromValue;
        this.animatePropertyBy(constantName, fromValue, deltaValue);
    }

    private void animatePropertyBy(int constantName, float byValue) {
        float fromValue = this.getValue(constantName);
        this.animatePropertyBy(constantName, fromValue, byValue);
    }

    private void animatePropertyBy(int constantName, float startValue, float byValue) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animatorToCancel = null;
            Set<Animator> animatorSet = this.mAnimatorMap.keySet();
            for (Animator runningAnim : animatorSet) {
                PropertyBundle bundle = this.mAnimatorMap.get(runningAnim);
                if (!bundle.cancel(constantName) || bundle.mPropertyMask != 0) continue;
                animatorToCancel = runningAnim;
                break;
            }
            if (animatorToCancel != null) {
                animatorToCancel.cancel();
            }
        }
        NameValuesHolder nameValuePair = new NameValuesHolder(constantName, startValue, byValue);
        this.mPendingAnimations.add(nameValuePair);
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.mView.post(this.mAnimationStarter);
    }

    private void setValue(int propertyConstant, float value) {
        View.TransformationInfo info = this.mView.mTransformationInfo;
        switch (propertyConstant) {
            case 1: {
                info.mTranslationX = value;
                break;
            }
            case 2: {
                info.mTranslationY = value;
                break;
            }
            case 16: {
                info.mRotation = value;
                break;
            }
            case 32: {
                info.mRotationX = value;
                break;
            }
            case 64: {
                info.mRotationY = value;
                break;
            }
            case 4: {
                info.mScaleX = value;
                break;
            }
            case 8: {
                info.mScaleY = value;
                break;
            }
            case 128: {
                info.mTranslationX = value - (float)this.mView.mLeft;
                break;
            }
            case 256: {
                info.mTranslationY = value - (float)this.mView.mTop;
                break;
            }
            case 512: {
                info.mAlpha = value;
            }
        }
    }

    private float getValue(int propertyConstant) {
        View.TransformationInfo info = this.mView.mTransformationInfo;
        switch (propertyConstant) {
            case 1: {
                return info.mTranslationX;
            }
            case 2: {
                return info.mTranslationY;
            }
            case 16: {
                return info.mRotation;
            }
            case 32: {
                return info.mRotationX;
            }
            case 64: {
                return info.mRotationY;
            }
            case 4: {
                return info.mScaleX;
            }
            case 8: {
                return info.mScaleY;
            }
            case 128: {
                return (float)this.mView.mLeft + info.mTranslationX;
            }
            case 256: {
                return (float)this.mView.mTop + info.mTranslationY;
            }
            case 512: {
                return info.mAlpha;
            }
        }
        return 0.0f;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        public void onAnimationStart(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationStart(animation);
            }
        }

        public void onAnimationCancel(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationCancel(animation);
            }
        }

        public void onAnimationRepeat(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationRepeat(animation);
            }
        }

        public void onAnimationEnd(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationEnd(animation);
            }
            ViewPropertyAnimator.this.mAnimatorMap.remove(animation);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            ArrayList<NameValuesHolder> valueList;
            boolean alphaHandled = false;
            ViewPropertyAnimator.this.mView.invalidateParentCaches();
            float fraction2 = animation.getAnimatedFraction();
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimator.this.mAnimatorMap.get(animation);
            int propertyMask = propertyBundle.mPropertyMask;
            if ((propertyMask & 0x1FF) != 0) {
                ViewPropertyAnimator.this.mView.invalidate(false);
            }
            if ((valueList = propertyBundle.mNameValuesHolder) != null) {
                int count = valueList.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder values = valueList.get(i);
                    float value = values.mFromValue + fraction2 * values.mDeltaValue;
                    if (values.mNameConstant == 512) {
                        alphaHandled = ViewPropertyAnimator.this.mView.setAlphaNoInvalidation(value);
                        continue;
                    }
                    ViewPropertyAnimator.this.setValue(values.mNameConstant, value);
                }
            }
            if ((propertyMask & 0x1FF) != 0) {
                ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mTransformationInfo.mMatrixDirty = true;
                ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mPrivateFlags |= 0x20;
            }
            ViewPropertyAnimator.this.mView.invalidate(alphaHandled);
        }
    }

    private static class NameValuesHolder {
        int mNameConstant;
        float mFromValue;
        float mDeltaValue;

        NameValuesHolder(int nameConstant, float fromValue, float deltaValue) {
            this.mNameConstant = nameConstant;
            this.mFromValue = fromValue;
            this.mDeltaValue = deltaValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyBundle {
        int mPropertyMask;
        ArrayList<NameValuesHolder> mNameValuesHolder;

        PropertyBundle(int propertyMask, ArrayList<NameValuesHolder> nameValuesHolder) {
            this.mPropertyMask = propertyMask;
            this.mNameValuesHolder = nameValuesHolder;
        }

        boolean cancel(int propertyConstant) {
            if ((this.mPropertyMask & propertyConstant) != 0 && this.mNameValuesHolder != null) {
                int count = this.mNameValuesHolder.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != propertyConstant) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~propertyConstant;
                    return true;
                }
            }
            return false;
        }
    }
}

