/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import java.util.LinkedList;
import java.util.Queue;

public class SpellCheckerSession {
    private static final String TAG = SpellCheckerSession.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String SERVICE_META_DATA = "android.view.textservice.scs";
    private static final int MSG_ON_GET_SUGGESTION_MULTIPLE = 1;
    private final InternalListener mInternalListener;
    private final ITextServicesManager mTextServicesManager;
    private final SpellCheckerInfo mSpellCheckerInfo;
    private final SpellCheckerSessionListenerImpl mSpellCheckerSessionListenerImpl;
    private boolean mIsUsed;
    private SpellCheckerSessionListener mSpellCheckerSessionListener;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SpellCheckerSession.this.handleOnGetSuggestionsMultiple((SuggestionsInfo[])msg.obj);
                }
            }
        }
    };

    public SpellCheckerSession(SpellCheckerInfo info, ITextServicesManager tsm, SpellCheckerSessionListener listener) {
        if (info == null || listener == null || tsm == null) {
            throw new NullPointerException();
        }
        this.mSpellCheckerInfo = info;
        this.mSpellCheckerSessionListenerImpl = new SpellCheckerSessionListenerImpl(this.mHandler);
        this.mInternalListener = new InternalListener(this.mSpellCheckerSessionListenerImpl);
        this.mTextServicesManager = tsm;
        this.mIsUsed = true;
        this.mSpellCheckerSessionListener = listener;
    }

    public boolean isSessionDisconnected() {
        return this.mSpellCheckerSessionListenerImpl.isDisconnected();
    }

    public SpellCheckerInfo getSpellChecker() {
        return this.mSpellCheckerInfo;
    }

    public void cancel() {
        this.mSpellCheckerSessionListenerImpl.cancel();
    }

    public void close() {
        this.mIsUsed = false;
        try {
            this.mSpellCheckerSessionListenerImpl.close();
            this.mTextServicesManager.finishSpellCheckerService(this.mSpellCheckerSessionListenerImpl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void getSuggestions(TextInfo textInfo, int suggestionsLimit) {
        this.getSuggestions(new TextInfo[]{textInfo}, suggestionsLimit, false);
    }

    public void getSuggestions(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
        this.mSpellCheckerSessionListenerImpl.getSuggestionsMultiple(textInfos, suggestionsLimit, sequentialWords);
    }

    private void handleOnGetSuggestionsMultiple(SuggestionsInfo[] suggestionInfos) {
        this.mSpellCheckerSessionListener.onGetSuggestions(suggestionInfos);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mIsUsed) {
            Log.e(TAG, "SpellCheckerSession was not finished properly.You should call finishShession() when you finished to use a spell checker.");
            this.close();
        }
    }

    public ITextServicesSessionListener getTextServicesSessionListener() {
        return this.mInternalListener;
    }

    public ISpellCheckerSessionListener getSpellCheckerSessionListener() {
        return this.mSpellCheckerSessionListenerImpl;
    }

    private static class InternalListener
    extends ITextServicesSessionListener.Stub {
        private final SpellCheckerSessionListenerImpl mParentSpellCheckerSessionListenerImpl;

        public InternalListener(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.mParentSpellCheckerSessionListenerImpl = spellCheckerSessionListenerImpl;
        }

        public void onServiceConnected(ISpellCheckerSession session) {
            this.mParentSpellCheckerSessionListenerImpl.onServiceConnected(session);
        }
    }

    public static interface SpellCheckerSessionListener {
        public void onGetSuggestions(SuggestionsInfo[] var1);
    }

    private static class SpellCheckerSessionListenerImpl
    extends ISpellCheckerSessionListener.Stub {
        private static final int TASK_CANCEL = 1;
        private static final int TASK_GET_SUGGESTIONS_MULTIPLE = 2;
        private static final int TASK_CLOSE = 3;
        private final Queue<SpellCheckerParams> mPendingTasks = new LinkedList<SpellCheckerParams>();
        private Handler mHandler;
        private boolean mOpened = false;
        private ISpellCheckerSession mISpellCheckerSession;
        private HandlerThread mThread;
        private Handler mAsyncHandler;

        public SpellCheckerSessionListenerImpl(Handler handler) {
            this.mHandler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTask(ISpellCheckerSession session, SpellCheckerParams scp, boolean async) {
            if (async || this.mAsyncHandler == null) {
                switch (scp.mWhat) {
                    case 1: {
                        try {
                            session.onCancel();
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to cancel " + e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            session.onGetSuggestionsMultiple(scp.mTextInfos, scp.mSuggestionsLimit, scp.mSequentialWords);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to get suggestions " + e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            session.onClose();
                            break;
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to close " + e);
                        }
                    }
                }
            } else {
                scp.mSession = session;
                this.mAsyncHandler.sendMessage(Message.obtain(this.mAsyncHandler, 1, scp));
            }
            if (scp.mWhat == 3) {
                SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
                synchronized (spellCheckerSessionListenerImpl) {
                    this.mISpellCheckerSession = null;
                    this.mHandler = null;
                    if (this.mThread != null) {
                        this.mThread.quit();
                    }
                    this.mThread = null;
                    this.mAsyncHandler = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onServiceConnected(ISpellCheckerSession session) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                this.mISpellCheckerSession = session;
                if (session.asBinder() instanceof Binder && this.mThread == null) {
                    this.mThread = new HandlerThread("SpellCheckerSession", 10);
                    this.mThread.start();
                    this.mAsyncHandler = new Handler(this.mThread.getLooper()){

                        public void handleMessage(Message msg) {
                            SpellCheckerParams scp = (SpellCheckerParams)msg.obj;
                            SpellCheckerSessionListenerImpl.this.processTask(scp.mSession, scp, true);
                        }
                    };
                }
                this.mOpened = true;
            }
            while (!this.mPendingTasks.isEmpty()) {
                this.processTask(session, this.mPendingTasks.poll(), false);
            }
        }

        public void cancel() {
            this.processOrEnqueueTask(new SpellCheckerParams(1, null, 0, false));
        }

        public void getSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
            this.processOrEnqueueTask(new SpellCheckerParams(2, textInfos, suggestionsLimit, sequentialWords));
        }

        public void close() {
            this.processOrEnqueueTask(new SpellCheckerParams(3, null, 0, false));
        }

        public boolean isDisconnected() {
            return this.mOpened && this.mISpellCheckerSession == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processOrEnqueueTask(SpellCheckerParams scp) {
            ISpellCheckerSession session;
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                session = this.mISpellCheckerSession;
                if (session == null) {
                    SpellCheckerParams closeTask = null;
                    if (scp.mWhat == 1) {
                        while (!this.mPendingTasks.isEmpty()) {
                            SpellCheckerParams tmp = this.mPendingTasks.poll();
                            if (tmp.mWhat != 3) continue;
                            closeTask = tmp;
                        }
                    }
                    this.mPendingTasks.offer(scp);
                    if (closeTask != null) {
                        this.mPendingTasks.offer(closeTask);
                    }
                    return;
                }
            }
            this.processTask(session, scp, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGetSuggestions(SuggestionsInfo[] results) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                if (this.mHandler != null) {
                    this.mHandler.sendMessage(Message.obtain(this.mHandler, 1, results));
                }
            }
        }

        private static class SpellCheckerParams {
            public final int mWhat;
            public final TextInfo[] mTextInfos;
            public final int mSuggestionsLimit;
            public final boolean mSequentialWords;
            public ISpellCheckerSession mSession;

            public SpellCheckerParams(int what, TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
                this.mWhat = what;
                this.mTextInfos = textInfos;
                this.mSuggestionsLimit = suggestionsLimit;
                this.mSequentialWords = sequentialWords;
            }
        }
    }
}

