/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import android.webkit.HTML5VideoView;
import android.webkit.HTML5VideoViewProxy;

public class HTML5VideoInline
extends HTML5VideoView {
    private static SurfaceTexture mSurfaceTexture = null;
    private int[] mTextureNames;
    private static int mVideoLayerUsingSurfaceTexture = -1;

    public void start() {
        if (!this.getPauseDuringPreparing()) {
            super.start();
        }
    }

    HTML5VideoInline(int videoLayerId, int position, boolean autoStart) {
        this.init(videoLayerId, position, autoStart);
        this.mTextureNames = null;
    }

    public void decideDisplayMode() {
        SurfaceTexture surfaceTexture = this.getSurfaceTexture(this.getVideoLayerId());
        Surface surface = new Surface(surfaceTexture);
        this.mPlayer.setSurface(surface);
        surface.release();
    }

    public void prepareDataAndDisplayMode(HTML5VideoViewProxy proxy) {
        super.prepareDataAndDisplayMode(proxy);
        this.setFrameAvailableListener(proxy);
        if (this.mProxy.getContext().checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
            this.mPlayer.setWakeMode(proxy.getContext(), 26);
        }
    }

    public void pauseAndDispatch(HTML5VideoViewProxy proxy) {
        super.pauseAndDispatch(proxy);
    }

    public SurfaceTexture getSurfaceTexture(int videoLayerId) {
        if (videoLayerId != mVideoLayerUsingSurfaceTexture || mSurfaceTexture == null || this.mTextureNames == null) {
            if (this.mTextureNames != null) {
                GLES20.glDeleteTextures(1, this.mTextureNames, 0);
            }
            this.mTextureNames = new int[1];
            GLES20.glGenTextures(1, this.mTextureNames, 0);
            mSurfaceTexture = new SurfaceTexture(this.mTextureNames[0]);
        }
        mVideoLayerUsingSurfaceTexture = videoLayerId;
        return mSurfaceTexture;
    }

    public boolean surfaceTextureDeleted() {
        return mSurfaceTexture == null;
    }

    public void deleteSurfaceTexture() {
        mSurfaceTexture = null;
        mVideoLayerUsingSurfaceTexture = -1;
    }

    public int getTextureName() {
        if (this.mTextureNames != null) {
            return this.mTextureNames[0];
        }
        return 0;
    }

    private void setFrameAvailableListener(SurfaceTexture.OnFrameAvailableListener l) {
        mSurfaceTexture.setOnFrameAvailableListener(l);
    }
}

