/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.CallbackProxy;
import android.webkit.SearchBox;
import android.webkit.WebViewCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchBoxImpl
implements SearchBox {
    private static final String TAG = "WebKit.SearchBoxImpl";
    static final String JS_INTERFACE_NAME = "searchBoxJavaBridge_";
    static final String JS_BRIDGE = "(function(){if (!window.chrome) {  window.chrome = {};}if (!window.chrome.searchBox) {  var sb = window.chrome.searchBox = {};  sb.setSuggestions = function(suggestions) {    if (window.searchBoxJavaBridge_) {      window.searchBoxJavaBridge_.setSuggestions(JSON.stringify(suggestions));    }  };  sb.setValue = function(valueArray) { sb.value = valueArray[0]; };  sb.value = '';  sb.x = 0;  sb.y = 0;  sb.width = 0;  sb.height = 0;  sb.selectionStart = 0;  sb.selectionEnd = 0;  sb.verbatim = false;}})();";
    private static final String SET_QUERY_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  window.chrome.searchBox.setValue(%s);}";
    private static final String SET_VERBATIM_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  window.chrome.searchBox.verbatim = %1$s;}";
    private static final String SET_SELECTION_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  var f = window.chrome.searchBox;  f.selectionStart = %d  f.selectionEnd = %d}";
    private static final String SET_DIMENSIONS_SCRIPT = "if (window.chrome && window.chrome.searchBox) {   var f = window.chrome.searchBox;  f.x = %d;  f.y = %d;  f.width = %d;  f.height = %d;}";
    private static final String DISPATCH_EVENT_SCRIPT = "if (window.chrome && window.chrome.searchBox && window.chrome.searchBox.on%1$s) {  window.chrome.searchBox.on%1$s();  window.searchBoxJavaBridge_.dispatchCompleteCallback('%1$s', %2$d, true);} else {  window.searchBoxJavaBridge_.dispatchCompleteCallback('%1$s', %2$d, false);}";
    private static final String EVENT_CHANGE = "change";
    private static final String EVENT_SUBMIT = "submit";
    private static final String EVENT_RESIZE = "resize";
    private static final String EVENT_CANCEL = "cancel";
    private static final String IS_SUPPORTED_SCRIPT = "if (window.searchBoxJavaBridge_) {  if (window.chrome && window.chrome.sv) {    window.searchBoxJavaBridge_.isSupportedCallback(true);  } else {    window.searchBoxJavaBridge_.isSupportedCallback(false);  }}";
    private final List<SearchBox.SearchBoxListener> mListeners = new ArrayList<SearchBox.SearchBoxListener>();
    private final WebViewCore mWebViewCore;
    private final CallbackProxy mCallbackProxy;
    private SearchBox.IsSupportedCallback mSupportedCallback;
    private int mNextEventId = 1;
    private final HashMap<Integer, SearchBox.SearchBoxListener> mEventCallbacks;

    SearchBoxImpl(WebViewCore webViewCore, CallbackProxy callbackProxy) {
        this.mWebViewCore = webViewCore;
        this.mCallbackProxy = callbackProxy;
        this.mEventCallbacks = new HashMap();
    }

    @Override
    public void setQuery(String query) {
        String formattedQuery = SearchBoxImpl.jsonSerialize(query);
        if (formattedQuery != null) {
            String js = String.format(SET_QUERY_SCRIPT, formattedQuery);
            this.dispatchJs(js);
        }
    }

    @Override
    public void setVerbatim(boolean verbatim) {
        String js = String.format(SET_VERBATIM_SCRIPT, String.valueOf(verbatim));
        this.dispatchJs(js);
    }

    @Override
    public void setSelection(int selectionStart, int selectionEnd) {
        String js = String.format(SET_SELECTION_SCRIPT, selectionStart, selectionEnd);
        this.dispatchJs(js);
    }

    @Override
    public void setDimensions(int x, int y, int width, int height) {
        String js = String.format(SET_DIMENSIONS_SCRIPT, x, y, width, height);
        this.dispatchJs(js);
    }

    @Override
    public void onchange(SearchBox.SearchBoxListener callback) {
        this.dispatchEvent(EVENT_CHANGE, callback);
    }

    @Override
    public void onsubmit(SearchBox.SearchBoxListener callback) {
        this.dispatchEvent(EVENT_SUBMIT, callback);
    }

    @Override
    public void onresize(SearchBox.SearchBoxListener callback) {
        this.dispatchEvent(EVENT_RESIZE, callback);
    }

    @Override
    public void oncancel(SearchBox.SearchBoxListener callback) {
        this.dispatchEvent(EVENT_CANCEL, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String eventName, SearchBox.SearchBoxListener callback) {
        int eventId;
        if (callback != null) {
            SearchBoxImpl searchBoxImpl = this;
            synchronized (searchBoxImpl) {
                eventId = this.mNextEventId++;
                this.mEventCallbacks.put(eventId, callback);
            }
        } else {
            eventId = 0;
        }
        String js = String.format(DISPATCH_EVENT_SCRIPT, eventName, eventId);
        this.dispatchJs(js);
    }

    private void dispatchJs(String js) {
        this.mWebViewCore.sendMessage(194, js);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchBoxListener(SearchBox.SearchBoxListener l) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchBoxListener(SearchBox.SearchBoxListener l) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.remove(l);
        }
    }

    @Override
    public void isSupported(SearchBox.IsSupportedCallback callback) {
        this.mSupportedCallback = callback;
        this.dispatchJs(IS_SUPPORTED_SCRIPT);
    }

    public void isSupportedCallback(boolean isSupported) {
        this.mCallbackProxy.onIsSupportedCallback(isSupported);
    }

    public void handleIsSupportedCallback(boolean isSupported) {
        SearchBox.IsSupportedCallback callback = this.mSupportedCallback;
        this.mSupportedCallback = null;
        if (callback != null) {
            callback.searchBoxIsSupported(isSupported);
        }
    }

    public void dispatchCompleteCallback(String function, int id2, boolean successful) {
        this.mCallbackProxy.onSearchboxDispatchCompleteCallback(function, id2, successful);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDispatchCompleteCallback(String function, int id2, boolean successful) {
        if (id2 != 0) {
            SearchBox.SearchBoxListener listener;
            SearchBoxImpl searchBoxImpl = this;
            synchronized (searchBoxImpl) {
                listener = this.mEventCallbacks.get(id2);
                this.mEventCallbacks.remove(id2);
            }
            if (listener != null) {
                if (TextUtils.equals(EVENT_CHANGE, function)) {
                    listener.onChangeComplete(successful);
                } else if (TextUtils.equals(EVENT_SUBMIT, function)) {
                    listener.onSubmitComplete(successful);
                } else if (TextUtils.equals(EVENT_RESIZE, function)) {
                    listener.onResizeComplete(successful);
                } else if (TextUtils.equals(EVENT_CANCEL, function)) {
                    listener.onCancelComplete(successful);
                }
            }
        }
    }

    private static String jsonSerialize(String query) {
        JSONStringer stringer = new JSONStringer();
        try {
            stringer.array().value(query).endArray();
        }
        catch (JSONException e) {
            Log.w(TAG, "Error serializing query : " + query);
            return null;
        }
        return stringer.toString();
    }

    public void setSuggestions(String jsonArguments) {
        if (jsonArguments == null) {
            return;
        }
        String query = null;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            JSONObject suggestionsJson = new JSONObject(jsonArguments);
            query = suggestionsJson.getString("query");
            JSONArray suggestionsArray = suggestionsJson.getJSONArray("suggestions");
            for (int i = 0; i < suggestionsArray.length(); ++i) {
                JSONObject suggestion = suggestionsArray.getJSONObject(i);
                String value = suggestion.getString("value");
                if (value == null) continue;
                suggestions.add(value);
            }
        }
        catch (JSONException je) {
            Log.w(TAG, "Error parsing json [" + jsonArguments + "], exception = " + je);
            return;
        }
        this.mCallbackProxy.onSearchboxSuggestionsReceived(query, suggestions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSuggestions(String query, List<String> suggestions) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                this.mListeners.get(i).onSuggestionsReceived(query, suggestions);
            }
        }
    }
}

