/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SslClientCertLookupTable {
    private static SslClientCertLookupTable sTable;
    private final Map<String, byte[]> privateKeys = new HashMap<String, byte[]>();
    private final Map<String, byte[][]> certificateChains = new HashMap<String, byte[][]>();
    private final Set<String> denied = new HashSet<String>();

    public static synchronized SslClientCertLookupTable getInstance() {
        if (sTable == null) {
            sTable = new SslClientCertLookupTable();
        }
        return sTable;
    }

    private SslClientCertLookupTable() {
    }

    public void Allow(String host_and_port, byte[] privateKey, byte[][] chain) {
        this.privateKeys.put(host_and_port, privateKey);
        this.certificateChains.put(host_and_port, chain);
        this.denied.remove(host_and_port);
    }

    public void Deny(String host_and_port) {
        this.privateKeys.remove(host_and_port);
        this.certificateChains.remove(host_and_port);
        this.denied.add(host_and_port);
    }

    public boolean IsAllowed(String host_and_port) {
        return this.privateKeys.containsKey(host_and_port);
    }

    public boolean IsDenied(String host_and_port) {
        return this.denied.contains(host_and_port);
    }

    public byte[] PrivateKey(String host_and_port) {
        return this.privateKeys.get(host_and_port);
    }

    public byte[][] CertificateChain(String host_and_port) {
        return this.certificateChains.get(host_and_port);
    }
}

