/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.Headers;
import android.os.Handler;
import android.os.Message;
import android.webkit.LoadListener;
import java.io.IOException;
import java.io.InputStream;

abstract class StreamLoader
implements Handler.Callback {
    private static final int MSG_STATUS = 100;
    private static final int MSG_HEADERS = 101;
    private static final int MSG_DATA = 102;
    private static final int MSG_END = 103;
    protected final Context mContext;
    protected final LoadListener mLoadListener;
    protected InputStream mDataStream;
    protected long mContentLength;
    private byte[] mData;
    private Handler mHandler;

    StreamLoader(LoadListener loadlistener) {
        this.mLoadListener = loadlistener;
        this.mContext = loadlistener.getContext();
    }

    protected abstract boolean setupStreamAndSendStatus();

    protected abstract void buildHeaders(Headers var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        StreamLoader streamLoader = this;
        synchronized (streamLoader) {
            if (this.mHandler == null) {
                this.mHandler = new Handler(this);
            }
        }
        if (!this.mLoadListener.isSynchronous()) {
            this.mHandler.sendEmptyMessage(100);
        } else if (this.setupStreamAndSendStatus()) {
            this.mData = new byte[8192];
            this.sendHeaders();
            while (!this.sendData() && !this.mLoadListener.cancelled()) {
            }
            this.closeStreamAndSendEndData();
            this.mLoadListener.loadSynchronousMessages();
        }
    }

    public boolean handleMessage(Message msg) {
        if (this.mLoadListener.isSynchronous()) {
            throw new AssertionError();
        }
        if (this.mLoadListener.cancelled()) {
            this.closeStreamAndSendEndData();
            return true;
        }
        switch (msg.what) {
            case 100: {
                if (!this.setupStreamAndSendStatus()) break;
                this.mData = new byte[8192];
                this.mHandler.sendEmptyMessage(101);
                break;
            }
            case 101: {
                this.sendHeaders();
                this.mHandler.sendEmptyMessage(102);
                break;
            }
            case 102: {
                if (this.sendData()) {
                    this.mHandler.sendEmptyMessage(103);
                    break;
                }
                this.mHandler.sendEmptyMessage(102);
                break;
            }
            case 103: {
                this.closeStreamAndSendEndData();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void sendHeaders() {
        Headers headers = new Headers();
        if (this.mContentLength > 0L) {
            headers.setContentLength(this.mContentLength);
        }
        this.buildHeaders(headers);
        this.mLoadListener.headers(headers);
    }

    private boolean sendData() {
        if (this.mDataStream != null) {
            try {
                int amount = this.mDataStream.read(this.mData);
                if (amount > 0) {
                    this.mLoadListener.data(this.mData, amount);
                    return false;
                }
            }
            catch (IOException ex) {
                this.mLoadListener.error(-13, ex.getMessage());
            }
        }
        return true;
    }

    private void closeStreamAndSendEndData() {
        if (this.mDataStream != null) {
            try {
                this.mDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mLoadListener.endData();
    }
}

