/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Bitmap;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.MalformedURLException;
import java.net.URL;

public class WebHistoryItem
implements Cloneable {
    private static int sNextId = 0;
    private final int mId;
    private String mTitle;
    private String mUrl;
    private String mOriginalUrl;
    private Bitmap mFavicon;
    private byte[] mFlattenedData;
    private String mTouchIconUrlFromLink;
    private String mTouchIconUrlServerDefault;
    private Object mCustomData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebHistoryItem() {
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebHistoryItem(byte[] data) {
        this.mUrl = null;
        this.mFlattenedData = data;
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private WebHistoryItem(WebHistoryItem item) {
        this.mUrl = item.mUrl;
        this.mTitle = item.mTitle;
        this.mFlattenedData = item.mFlattenedData;
        this.mFavicon = item.mFavicon;
        this.mId = item.mId;
    }

    @Deprecated
    public int getId() {
        return this.mId;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getOriginalUrl() {
        return this.mOriginalUrl;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    public String getTouchIconUrl() {
        if (this.mTouchIconUrlFromLink != null) {
            return this.mTouchIconUrlFromLink;
        }
        if (this.mTouchIconUrlServerDefault != null) {
            return this.mTouchIconUrlServerDefault;
        }
        try {
            URL url = new URL(this.mOriginalUrl);
            this.mTouchIconUrlServerDefault = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/apple-touch-icon.png").toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.mTouchIconUrlServerDefault;
    }

    public Object getCustomData() {
        return this.mCustomData;
    }

    public void setCustomData(Object data) {
        this.mCustomData = data;
    }

    void setFavicon(Bitmap icon) {
        this.mFavicon = icon;
    }

    void setTouchIconUrl(String url, boolean precomposed) {
        if (precomposed || this.mTouchIconUrlFromLink == null) {
            this.mTouchIconUrlFromLink = url;
        }
    }

    byte[] getFlattenedData() {
        return this.mFlattenedData;
    }

    void inflate(int nativeFrame) {
        this.inflate(nativeFrame, this.mFlattenedData);
    }

    protected synchronized WebHistoryItem clone() {
        return new WebHistoryItem(this);
    }

    private void inflate(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.webkit.WebHistoryItem#inflate(I[B)V", true, this);
    }

    private void update(String url, String originalUrl, String title, Bitmap favicon, byte[] data) {
        this.mUrl = url;
        this.mOriginalUrl = originalUrl;
        this.mTitle = title;
        this.mFavicon = favicon;
        this.mFlattenedData = data;
    }
}

