/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.android.internal.R;

public class QuickContactBadge
extends ImageView
implements View.OnClickListener {
    private Uri mContactUri;
    private String mContactEmail;
    private String mContactPhone;
    private Drawable mOverlay;
    private QueryHandler mQueryHandler;
    private Drawable mDefaultAvatar;
    protected String[] mExcludeMimes = null;
    private static final int TOKEN_EMAIL_LOOKUP = 0;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_EMAIL_LOOKUP_AND_TRIGGER = 2;
    private static final int TOKEN_PHONE_LOOKUP_AND_TRIGGER = 3;
    static final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
    static final int EMAIL_ID_COLUMN_INDEX = 0;
    static final int EMAIL_LOOKUP_STRING_COLUMN_INDEX = 1;
    static final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
    static final int PHONE_ID_COLUMN_INDEX = 0;
    static final int PHONE_LOOKUP_STRING_COLUMN_INDEX = 1;

    public QuickContactBadge(Context context) {
        this(context, null);
    }

    public QuickContactBadge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray styledAttributes = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mOverlay = styledAttributes.getDrawable(228);
        styledAttributes.recycle();
        this.mQueryHandler = new QueryHandler(this.mContext.getContentResolver());
        this.setOnClickListener(this);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mOverlay != null && this.mOverlay.isStateful()) {
            this.mOverlay.setState(this.getDrawableState());
            this.invalidate();
        }
    }

    public void setMode(int size) {
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isEnabled()) {
            return;
        }
        if (this.mOverlay == null || this.mOverlay.getIntrinsicWidth() == 0 || this.mOverlay.getIntrinsicHeight() == 0) {
            return;
        }
        this.mOverlay.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mOverlay.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            this.mOverlay.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    private boolean isAssigned() {
        return this.mContactUri != null || this.mContactEmail != null || this.mContactPhone != null;
    }

    public void setImageToDefault() {
        if (this.mDefaultAvatar == null) {
            this.mDefaultAvatar = this.getResources().getDrawable(17302198);
        }
        this.setImageDrawable(this.mDefaultAvatar);
    }

    public void assignContactUri(Uri contactUri) {
        this.mContactUri = contactUri;
        this.mContactEmail = null;
        this.mContactPhone = null;
        this.onContactUriChanged();
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup) {
        this.mContactEmail = emailAddress;
        if (!lazyLookup) {
            this.mQueryHandler.startQuery(0, null, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup) {
        this.mContactPhone = phoneNumber;
        if (!lazyLookup) {
            this.mQueryHandler.startQuery(1, null, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    private void onContactUriChanged() {
        this.setEnabled(this.isAssigned());
    }

    public void onClick(View v) {
        if (this.mContactUri != null) {
            ContactsContract.QuickContact.showQuickContact(this.getContext(), this, this.mContactUri, 3, this.mExcludeMimes);
        } else if (this.mContactEmail != null) {
            this.mQueryHandler.startQuery(2, this.mContactEmail, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else if (this.mContactPhone != null) {
            this.mQueryHandler.startQuery(3, this.mContactPhone, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            return;
        }
    }

    public void setExcludeMimes(String[] excludeMimes) {
        this.mExcludeMimes = excludeMimes;
    }

    static /* synthetic */ Uri access$002(QuickContactBadge x0, Uri x1) {
        x0.mContactUri = x1;
        return x0.mContactUri;
    }

    static /* synthetic */ void access$100(QuickContactBadge x0) {
        x0.onContactUriChanged();
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver cr) {
            super(cr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            lookupUri = null;
            createUri = null;
            trigger = false;
            try {
                switch (token) {
                    case 3: {
                        trigger = true;
                        createUri = Uri.fromParts("tel", (String)cookie, null);
                    }
                    case 1: {
                        if (cursor != null && cursor.moveToFirst()) {
                            contactId = cursor.getLong(0);
                            lookupKey = cursor.getString(1);
                            lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                            ** break;
                        }
lbl15:
                        // 3 sources

                        break;
                    }
                    case 2: {
                        trigger = true;
                        createUri = Uri.fromParts("mailto", (String)cookie, null);
                    }
                    case 0: {
                        if (cursor != null && cursor.moveToFirst()) {
                            contactId = cursor.getLong(0);
                            lookupKey = cursor.getString(1);
                            lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                        }
                        break;
                    }
                    ** default:
lbl26:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            QuickContactBadge.access$002(QuickContactBadge.this, lookupUri);
            QuickContactBadge.access$100(QuickContactBadge.this);
            if (trigger && lookupUri != null) {
                ContactsContract.QuickContact.showQuickContact(QuickContactBadge.this.getContext(), QuickContactBadge.this, lookupUri, 3, QuickContactBadge.this.mExcludeMimes);
            } else if (createUri != null) {
                intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", createUri);
                QuickContactBadge.this.getContext().startActivity(intent);
            }
        }
    }
}

