/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionAc;
import com.android.internal.telephony.DataConnectionTracker;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApnContext {
    public final String LOG_TAG;
    protected static final boolean DBG = true;
    private final String mApnType;
    private DataConnectionTracker.State mState;
    private ArrayList<ApnSetting> mWaitingApns = null;
    private AtomicInteger mWaitingApnsPermanentFailureCountDown;
    private ApnSetting mApnSetting;
    DataConnection mDataConnection;
    DataConnectionAc mDataConnectionAc;
    String mReason;
    AtomicBoolean mDataEnabled;
    AtomicBoolean mDependencyMet;

    public ApnContext(String apnType, String logTag) {
        this.mApnType = apnType;
        this.mState = DataConnectionTracker.State.IDLE;
        this.setReason("dataEnabled");
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(true);
        this.mWaitingApnsPermanentFailureCountDown = new AtomicInteger(0);
        this.LOG_TAG = logTag;
    }

    public String getApnType() {
        return this.mApnType;
    }

    public synchronized DataConnection getDataConnection() {
        return this.mDataConnection;
    }

    public synchronized void setDataConnection(DataConnection dataConnection) {
        this.mDataConnection = dataConnection;
    }

    public synchronized DataConnectionAc getDataConnectionAc() {
        return this.mDataConnectionAc;
    }

    public synchronized void setDataConnectionAc(DataConnectionAc dcac) {
        if (dcac != null) {
            dcac.addApnContextSync(this);
        } else if (this.mDataConnectionAc != null) {
            this.mDataConnectionAc.removeApnContextSync(this);
        }
        this.mDataConnectionAc = dcac;
    }

    public synchronized ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        this.mApnSetting = apnSetting;
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mWaitingApns = waitingApns;
        this.mWaitingApnsPermanentFailureCountDown.set(this.mWaitingApns.size());
    }

    public int getWaitingApnsPermFailCount() {
        return this.mWaitingApnsPermanentFailureCountDown.get();
    }

    public void decWaitingApnsPermFailCount() {
        this.mWaitingApnsPermanentFailureCountDown.decrementAndGet();
    }

    public synchronized ApnSetting getNextWaitingApn() {
        ArrayList<ApnSetting> list = this.mWaitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public synchronized void removeNextWaitingApn() {
        if (this.mWaitingApns != null && !this.mWaitingApns.isEmpty()) {
            this.mWaitingApns.remove(0);
        }
    }

    public synchronized ArrayList<ApnSetting> getWaitingApns() {
        return this.mWaitingApns;
    }

    public synchronized void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s) + " for type " + this.mApnType + ", previous state:" + (Object)((Object)this.mState));
        this.mState = s;
        if (this.mState == DataConnectionTracker.State.FAILED && this.mWaitingApns != null) {
            this.mWaitingApns.clear();
        }
    }

    public synchronized DataConnectionTracker.State getState() {
        return this.mState;
    }

    public boolean isDisconnected() {
        DataConnectionTracker.State currentState = this.getState();
        return currentState == DataConnectionTracker.State.IDLE || currentState == DataConnectionTracker.State.FAILED;
    }

    public synchronized void setReason(String reason) {
        this.log("set reason as " + reason + ", for type " + this.mApnType + ",current state " + (Object)((Object)this.mState));
        this.mReason = reason;
    }

    public synchronized String getReason() {
        return this.mReason;
    }

    public boolean isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    public void setEnabled(boolean enabled) {
        this.log("set enabled as " + enabled + ", for type " + this.mApnType + ", current state is " + this.mDataEnabled.get());
        this.mDataEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.mDataEnabled.get();
    }

    public void setDependencyMet(boolean met) {
        this.log("set mDependencyMet as " + met + ", for type " + this.mApnType + ", current state is " + this.mDependencyMet.get());
        this.mDependencyMet.set(met);
    }

    public boolean getDependencyMet() {
        return this.mDependencyMet.get();
    }

    public String toString() {
        return "state=" + (Object)((Object)this.getState()) + " apnType=" + this.mApnType;
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, "[ApnContext] " + s);
    }
}

