/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CdmaServiceStateTracker
extends ServiceStateTracker {
    static final String LOG_TAG = "CDMA";
    CDMAPhone phone;
    CdmaCellLocation cellLoc;
    CdmaCellLocation newCellLoc;
    private static final String UNACTIVATED_MIN2_VALUE = "000000";
    private static final String UNACTIVATED_MIN_VALUE = "1111110111";
    int mCurrentOtaspMode = 0;
    private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    private int mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
    private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    private int mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
    protected int networkType = 0;
    protected int newNetworkType = 0;
    private boolean mCdmaRoaming = false;
    private int mRoamingIndicator;
    private boolean mIsInPrl;
    private int mDefaultRoamingIndicator;
    protected int mDataConnectionState = 1;
    protected int mNewDataConnectionState = 1;
    protected int mRegistrationState = -1;
    protected RegistrantList cdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
    protected boolean mNeedFixZone = false;
    private int mZoneOffset;
    private boolean mZoneDst;
    private long mZoneTime;
    protected boolean mGotCountryCode = false;
    String mSavedTimeZone;
    long mSavedTime;
    long mSavedAtTime;
    private boolean mNeedToRegForRuimLoaded = false;
    private PowerManager.WakeLock mWakeLock;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    protected String mCurPlmn = null;
    protected String mMdn;
    protected int[] mHomeSystemId = null;
    protected int[] mHomeNetworkId = null;
    protected String mMin;
    protected String mPrlVersion;
    protected boolean mIsMinInfoReady = false;
    private boolean isEriTextLoaded = false;
    protected boolean isSubscriptionFromRuim = false;
    private String mRegistrationDeniedReason;
    private ContentResolver cr;
    private String currentCarrier = null;
    private ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            CdmaServiceStateTracker.this.log("Auto time state changed");
            CdmaServiceStateTracker.this.revertToNitzTime();
        }
    };
    private ContentObserver mAutoTimeZoneObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            CdmaServiceStateTracker.this.log("Auto time zone state changed");
            CdmaServiceStateTracker.this.revertToNitzTimeZone();
        }
    };

    public CdmaServiceStateTracker(CDMAPhone phone) {
        this.phone = phone;
        this.cr = phone.getContext().getContentResolver();
        this.cm = phone.mCM;
        this.ss = new ServiceState();
        this.newSS = new ServiceState();
        this.cellLoc = new CdmaCellLocation();
        this.newCellLoc = new CdmaCellLocation();
        this.mSignalStrength = new SignalStrength();
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForVoiceNetworkStateChanged(this, 30, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.registerForRUIMReady(this, 26, null);
        this.cm.registerForNVReady(this, 35, null);
        phone.registerForEriFileLoaded(this, 36, null);
        this.cm.registerForCdmaOtaProvision(this, 37, null);
        int airplaneMode = Settings.System.getInt(this.cr, "airplane_mode_on", 0);
        this.mDesiredPowerState = airplaneMode <= 0;
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time_zone"), true, this.mAutoTimeZoneObserver);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForRuimLoaded = true;
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForVoiceNetworkStateChanged(this);
        this.cm.unregisterForRUIMReady(this);
        this.cm.unregisterForNVReady(this);
        this.cm.unregisterForCdmaOtaProvision(this);
        this.phone.unregisterForEriFileLoaded(this);
        this.phone.mIccRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnNITZTime(this);
        this.cr.unregisterContentObserver(this.mAutoTimeObserver);
        this.cr.unregisterContentObserver(this.mAutoTimeZoneObserver);
    }

    protected void finalize() {
        this.log("CdmaServiceStateTracker finalized");
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.cdmaForSubscriptionInfoReadyRegistrants.add(r);
        if (this.isMinInfoReady()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.cdmaForSubscriptionInfoReadyRegistrants.remove(h);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                this.log("handleMessage: EVENT_RADIO_AVAILABLE");
                break;
            }
            case 26: {
                this.isSubscriptionFromRuim = true;
                if (this.mNeedToRegForRuimLoaded) {
                    this.phone.mIccRecords.registerForRecordsLoaded(this, 27, null);
                    this.mNeedToRegForRuimLoaded = false;
                }
                this.cm.getCDMASubscription(this.obtainMessage(34));
                this.log("handleMessage: EVENT_RUIM_READY, Send Request getCDMASubscription.");
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 35: {
                this.isSubscriptionFromRuim = false;
                this.log("handleMessage: EVENT_NV_READY, Send Request getCDMASubscription.");
                this.cm.getCDMASubscription(this.obtainMessage(34));
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: {
                this.setPowerStateToDesired();
                this.pollState();
                break;
            }
            case 30: {
                this.pollState();
                break;
            }
            case 3: {
                if (!this.cm.getRadioState().isOn() || this.cm.getRadioState().isGsm()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    String[] states = (String[])ar.result;
                    int baseStationId = -1;
                    int baseStationLatitude = Integer.MAX_VALUE;
                    int baseStationLongitude = Integer.MAX_VALUE;
                    int systemId = -1;
                    int networkId = -1;
                    if (states.length > 9) {
                        try {
                            if (states[4] != null) {
                                baseStationId = Integer.parseInt(states[4]);
                            }
                            if (states[5] != null) {
                                baseStationLatitude = Integer.parseInt(states[5]);
                            }
                            if (states[6] != null) {
                                baseStationLongitude = Integer.parseInt(states[6]);
                            }
                            if (baseStationLatitude == 0 && baseStationLongitude == 0) {
                                baseStationLatitude = Integer.MAX_VALUE;
                                baseStationLongitude = Integer.MAX_VALUE;
                            }
                            if (states[8] != null) {
                                systemId = Integer.parseInt(states[8]);
                            }
                            if (states[9] != null) {
                                networkId = Integer.parseInt(states[9]);
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.loge("error parsing cell location data: " + ex);
                        }
                    }
                    this.cellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                    this.phone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 24: 
            case 25: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] cdmaSubscription = (String[])ar.result;
                if (cdmaSubscription != null && cdmaSubscription.length >= 5) {
                    this.mMdn = cdmaSubscription[0];
                    this.parseSidNid(cdmaSubscription[1], cdmaSubscription[2]);
                    this.mMin = cdmaSubscription[3];
                    this.mPrlVersion = cdmaSubscription[4];
                    this.log("GET_CDMA_SUBSCRIPTION: MDN=" + this.mMdn);
                    this.mIsMinInfoReady = true;
                    this.updateOtaspState();
                    this.phone.getIccCard().broadcastIccStateChangedIntent("IMSI", null);
                    break;
                }
                this.log("GET_CDMA_SUBSCRIPTION: error parsing cdmaSubscription params num=" + cdmaSubscription.length);
                break;
            }
            case 10: {
                this.cm.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.dontPollSignalStrength = true;
                this.onSignalStrengthResult(ar);
                break;
            }
            case 27: {
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.cm.getVoiceRegistrationState(this.obtainMessage(31, null));
                break;
            }
            case 36: {
                this.log("[CdmaServiceStateTracker] ERI file has been loaded, repolling.");
                this.pollState();
                break;
            }
            case 37: {
                int[] ints;
                int otaStatus;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || (otaStatus = (ints = (int[])ar.result)[0]) != 8 && otaStatus != 10) break;
                this.log("EVENT_OTA_PROVISION_STATUS_CHANGE: Complete, Reload MDN");
                this.cm.getCDMASubscription(this.obtainMessage(34));
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.cm.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.cm.setRadioPower(true, null);
        } else if (!this.mDesiredPowerState && this.cm.getRadioState().isOn()) {
            DataConnectionTracker dcTracker = this.phone.mDataConnectionTracker;
            this.powerOffRadioSafely(dcTracker);
        }
    }

    protected void updateSpnDisplay() {
        String plmn = this.ss.getOperatorAlphaLong();
        if (!TextUtils.equals(plmn, this.mCurPlmn)) {
            boolean showPlmn = plmn != null;
            this.log(String.format("updateSpnDisplay: changed sending intent showPlmn='%b' plmn='%s'", showPlmn, plmn));
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", false);
            intent.putExtra("spn", "");
            intent.putExtra("showPlmn", showPlmn);
            intent.putExtra("plmn", plmn);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.mCurPlmn = plmn;
    }

    protected Phone getPhone() {
        return this.phone;
    }

    protected void setCdmaTechnology(int radioTechnology) {
        this.mNewDataConnectionState = this.radioTechnologyToDataServiceState(radioTechnology);
        this.newSS.setRadioTechnology(radioTechnology);
        this.newNetworkType = radioTechnology;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePollStateResultMessage(int what, AsyncResult ar) {
        switch (what) {
            case 24: {
                String[] states = (String[])ar.result;
                int registrationState = 4;
                int radioTechnology = -1;
                int baseStationId = -1;
                int baseStationLatitude = Integer.MAX_VALUE;
                int baseStationLongitude = Integer.MAX_VALUE;
                int cssIndicator = 0;
                int systemId = 0;
                int networkId = 0;
                int roamingIndicator = -1;
                int systemIsInPrl = 0;
                int defaultRoamingIndicator = 0;
                int reasonForDenial = 0;
                if (states.length < 14) throw new RuntimeException("Warning! Wrong number of parameters returned from RIL_REQUEST_REGISTRATION_STATE: expected 14 or more strings and got " + states.length + " strings");
                try {
                    if (states[0] != null) {
                        registrationState = Integer.parseInt(states[0]);
                    }
                    if (states[3] != null) {
                        radioTechnology = Integer.parseInt(states[3]);
                    }
                    if (states[4] != null) {
                        baseStationId = Integer.parseInt(states[4]);
                    }
                    if (states[5] != null) {
                        baseStationLatitude = Integer.parseInt(states[5]);
                    }
                    if (states[6] != null) {
                        baseStationLongitude = Integer.parseInt(states[6]);
                    }
                    if (baseStationLatitude == 0 && baseStationLongitude == 0) {
                        baseStationLatitude = Integer.MAX_VALUE;
                        baseStationLongitude = Integer.MAX_VALUE;
                    }
                    if (states[7] != null) {
                        cssIndicator = Integer.parseInt(states[7]);
                    }
                    if (states[8] != null) {
                        systemId = Integer.parseInt(states[8]);
                    }
                    if (states[9] != null) {
                        networkId = Integer.parseInt(states[9]);
                    }
                    if (states[10] != null) {
                        roamingIndicator = Integer.parseInt(states[10]);
                    }
                    if (states[11] != null) {
                        systemIsInPrl = Integer.parseInt(states[11]);
                    }
                    if (states[12] != null) {
                        defaultRoamingIndicator = Integer.parseInt(states[12]);
                    }
                    if (states[13] != null) {
                        reasonForDenial = Integer.parseInt(states[13]);
                    }
                }
                catch (NumberFormatException ex) {
                    this.loge("EVENT_POLL_STATE_REGISTRATION_CDMA: error parsing: " + ex);
                }
                this.mRegistrationState = registrationState;
                this.mCdmaRoaming = this.regCodeIsRoaming(registrationState) && !this.isRoamIndForHomeSystem(states[10]);
                this.newSS.setState(this.regCodeToServiceState(registrationState));
                this.setCdmaTechnology(radioTechnology);
                this.newSS.setCssIndicator(cssIndicator);
                this.newSS.setSystemAndNetworkId(systemId, networkId);
                this.mRoamingIndicator = roamingIndicator;
                this.mIsInPrl = systemIsInPrl != 0;
                this.mDefaultRoamingIndicator = defaultRoamingIndicator;
                this.newCellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                this.mRegistrationDeniedReason = reasonForDenial == 0 ? "General" : (reasonForDenial == 1 ? "Authentication Failure" : "");
                if (this.mRegistrationState != 3) return;
                this.log("Registration denied, " + this.mRegistrationDeniedReason);
                return;
            }
            case 25: {
                String[] opNames = (String[])ar.result;
                if (opNames != null && opNames.length >= 3) {
                    if (opNames[2] == null || opNames[2].length() < 5 || "00000".equals(opNames[2])) {
                        opNames[2] = SystemProperties.get(CDMAPhone.PROPERTY_CDMA_HOME_OPERATOR_NUMERIC, "00000");
                        this.log("RIL_REQUEST_OPERATOR.response[2], the numeric,  is bad. Using SystemProperties '" + CDMAPhone.PROPERTY_CDMA_HOME_OPERATOR_NUMERIC + "'= " + opNames[2]);
                    }
                    if (this.cm.getNvState().isNVReady()) {
                        this.newSS.setOperatorName(null, opNames[1], opNames[2]);
                        return;
                    }
                    this.newSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    return;
                }
                this.log("EVENT_POLL_STATE_OPERATOR_CDMA: error parsing opNames");
                return;
            }
        }
        this.loge("handlePollStateResultMessage: RIL response handle in wrong phone! Expected CDMA RIL request and get GSM RIL request.");
    }

    protected void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.pollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (!this.cm.getRadioState().isOn()) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                this.loge("handlePollStateResult: RIL returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                this.handlePollStateResultMessage(what, ar);
            }
            catch (RuntimeException ex) {
                this.loge("handlePollStateResult: Exception while polling service state. Probably malformed RIL response." + ex);
            }
        }
        this.pollingContext[0] = this.pollingContext[0] - 1;
        if (this.pollingContext[0] == 0) {
            boolean namMatch = false;
            if (!this.isSidsAllZeros() && this.isHomeSid(this.newSS.getSystemId())) {
                namMatch = true;
            }
            if (this.isSubscriptionFromRuim) {
                this.newSS.setRoaming(this.isRoamingBetweenOperators(this.mCdmaRoaming, this.newSS));
            } else {
                this.newSS.setRoaming(this.mCdmaRoaming);
            }
            this.newSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
            this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
            boolean isPrlLoaded = true;
            if (TextUtils.isEmpty(this.mPrlVersion)) {
                isPrlLoaded = false;
            }
            if (!isPrlLoaded) {
                this.newSS.setCdmaRoamingIndicator(1);
            } else if (!this.isSidsAllZeros()) {
                if (!namMatch && !this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
                } else if (namMatch && !this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(2);
                } else if (!namMatch && this.mIsInPrl) {
                    this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                } else if (this.mRoamingIndicator <= 2) {
                    this.newSS.setCdmaRoamingIndicator(1);
                } else {
                    this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                }
            }
            int roamingIndicator = this.newSS.getCdmaRoamingIndicator();
            this.newSS.setCdmaEriIconIndex(this.phone.mEriManager.getCdmaEriIconIndex(roamingIndicator, this.mDefaultRoamingIndicator));
            this.newSS.setCdmaEriIconMode(this.phone.mEriManager.getCdmaEriIconMode(roamingIndicator, this.mDefaultRoamingIndicator));
            this.log("Set CDMA Roaming Indicator to: " + this.newSS.getCdmaRoamingIndicator() + ". mCdmaRoaming = " + this.mCdmaRoaming + ", isPrlLoaded = " + isPrlLoaded + ". namMatch = " + namMatch + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
            this.pollStateDone();
        }
    }

    protected void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, false);
    }

    protected void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (this.cm.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case SIM_NOT_READY: 
            case SIM_LOCKED_OR_ABSENT: 
            case SIM_READY: {
                this.log("Radio Technology Change ongoing, setting SS to off");
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                break;
            }
            default: {
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getOperator(this.obtainMessage(25, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getVoiceRegistrationState(this.obtainMessage(24, this.pollingContext));
            }
        }
    }

    protected void fixTimeZone(String isoCountryCode) {
        TimeZone zone = null;
        String zoneName = SystemProperties.get("persist.sys.timezone");
        if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode) < 0) {
            zone = TimeZone.getDefault();
            long tzOffset = zone.getOffset(System.currentTimeMillis());
            if (this.getAutoTime()) {
                this.setAndBroadcastNetworkSetTime(System.currentTimeMillis() - tzOffset);
            } else {
                this.mSavedTime -= tzOffset;
            }
        } else {
            zone = isoCountryCode.equals("") ? this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime) : TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, isoCountryCode);
        }
        this.mNeedFixZone = false;
        if (zone != null) {
            if (this.getAutoTimeZone()) {
                this.setAndBroadcastNetworkSetTimeZone(zone.getID());
            }
            this.saveNitzTimeZone(zone.getID());
        }
    }

    protected void pollStateDone() {
        boolean hasLocationChanged;
        this.log("pollStateDone: oldSS=[" + this.ss + "] newSS=[" + this.newSS + "]");
        boolean hasRegistered = this.ss.getState() != 0 && this.newSS.getState() == 0;
        boolean hasDeregistered = this.ss.getState() == 0 && this.newSS.getState() != 0;
        boolean hasCdmaDataConnectionAttached = this.mDataConnectionState != 0 && this.mNewDataConnectionState == 0;
        boolean hasCdmaDataConnectionDetached = this.mDataConnectionState == 0 && this.mNewDataConnectionState != 0;
        boolean hasCdmaDataConnectionChanged = this.mDataConnectionState != this.mNewDataConnectionState;
        boolean hasNetworkTypeChanged = this.networkType != this.newNetworkType;
        boolean hasChanged = !this.newSS.equals(this.ss);
        boolean hasRoamingOn = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean hasRoamingOff = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean bl = hasLocationChanged = !this.newCellLoc.equals(this.cellLoc);
        if (this.ss.getState() != this.newSS.getState() || this.mDataConnectionState != this.mNewDataConnectionState) {
            EventLog.writeEvent(50116, this.ss.getState(), this.mDataConnectionState, this.newSS.getState(), this.mNewDataConnectionState);
        }
        ServiceState tss = this.ss;
        this.ss = this.newSS;
        this.newSS = tss;
        this.newSS.setStateOutOfService();
        CdmaCellLocation tcl = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = tcl;
        this.mDataConnectionState = this.mNewDataConnectionState;
        this.networkType = this.newNetworkType;
        this.newNetworkType = 0;
        this.newSS.setStateOutOfService();
        if (hasNetworkTypeChanged) {
            this.phone.setSystemProperty("gsm.network.type", ServiceState.radioTechnologyToString(this.networkType));
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            if (this.cm.getRadioState().isNVReady()) {
                String eriText = this.ss.getState() == 0 ? this.phone.getCdmaEriText() : ((Object)this.phone.getContext().getText(17039619)).toString();
                this.ss.setOperatorAlphaLong(eriText);
            }
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String operatorNumeric = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            if (operatorNumeric == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
                this.mGotCountryCode = false;
            } else {
                String isoCountryCode = "";
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", isoCountryCode);
                this.mGotCountryCode = true;
                if (this.mNeedFixZone) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            this.phone.setSystemProperty("gsm.operator.isroaming", this.ss.getRoaming() ? "true" : "false");
            this.updateSpnDisplay();
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (hasCdmaDataConnectionAttached) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasNetworkTypeChanged) {
            this.phone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.mRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.mRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.phone.notifyLocationChanged();
        }
    }

    private TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        this.log("getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    private TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    protected void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength || this.cm.getRadioState().isGsm()) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    protected void onSignalStrengthResult(AsyncResult ar) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        if (ar.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] ints = (int[])ar.result;
            int offset = 2;
            int cdmaDbm = ints[offset] > 0 ? -ints[offset] : -120;
            int cdmaEcio = ints[offset + 1] > 0 ? -ints[offset + 1] : -160;
            int evdoRssi = ints[offset + 2] > 0 ? -ints[offset + 2] : -120;
            int evdoEcio = ints[offset + 3] > 0 ? -ints[offset + 3] : -1;
            int evdoSnr = ints[offset + 4] > 0 && ints[offset + 4] <= 8 ? ints[offset + 4] : -1;
            this.mSignalStrength = new SignalStrength(99, -1, cdmaDbm, cdmaEcio, evdoRssi, evdoEcio, evdoSnr, false);
        }
        try {
            this.phone.notifySignalStrength();
        }
        catch (NullPointerException ex) {
            this.loge("onSignalStrengthResult() Phone already destroyed: " + ex + "SignalStrength not notified");
        }
    }

    protected int radioTechnologyToDataServiceState(int code) {
        int retVal = 1;
        switch (code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                retVal = 0;
                break;
            }
            default: {
                this.loge("radioTechnologyToDataServiceState: Wrong radioTechnology code.");
            }
        }
        return retVal;
    }

    protected int regCodeToServiceState(int code) {
        switch (code) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        this.loge("regCodeToServiceState: unexpected service state " + code);
        return 1;
    }

    public int getCurrentDataConnectionState() {
        return this.mDataConnectionState;
    }

    private boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    private boolean isRoamIndForHomeSystem(String roamInd) {
        String homeRoamIndicators = SystemProperties.get("ro.cdma.homesystem");
        if (!TextUtils.isEmpty(homeRoamIndicators)) {
            for (String homeRoamInd : homeRoamIndicators.split(",")) {
                if (!homeRoamInd.equals(roamInd)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isRoamingBetweenOperators(boolean cdmaRoaming, ServiceState s) {
        String spn = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = onsl != null && spn.equals(onsl);
        boolean equalsOnss = onss != null && spn.equals(onss);
        return cdmaRoaming && !equalsOnsl && !equalsOnss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        this.log("NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            String ignore;
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.clear();
            c.set(16, 0);
            String[] nitzSubs = nitz.split("[/:,+-]");
            int year = 2000 + Integer.parseInt(nitzSubs[0]);
            c.set(1, year);
            int month = Integer.parseInt(nitzSubs[1]) - 1;
            c.set(2, month);
            int date = Integer.parseInt(nitzSubs[2]);
            c.set(5, date);
            int hour = Integer.parseInt(nitzSubs[3]);
            c.set(10, hour);
            int minute = Integer.parseInt(nitzSubs[4]);
            c.set(12, minute);
            int second = Integer.parseInt(nitzSubs[5]);
            c.set(13, second);
            boolean sign = nitz.indexOf(45) == -1;
            int tzOffset = Integer.parseInt(nitzSubs[6]);
            int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
            tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
            TimeZone zone = null;
            if (nitzSubs.length >= 9) {
                String tzname = nitzSubs[8].replace('!', '/');
                zone = TimeZone.getTimeZone(tzname);
            }
            String iso = SystemProperties.get("gsm.operator.iso-country");
            if (zone == null && this.mGotCountryCode) {
                zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
            }
            if (zone == null) {
                this.mNeedFixZone = true;
                this.mZoneOffset = tzOffset;
                this.mZoneDst = dst != 0;
                this.mZoneTime = c.getTimeInMillis();
            }
            if (zone != null) {
                if (this.getAutoTimeZone()) {
                    this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                }
                this.saveNitzTimeZone(zone.getID());
            }
            if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                this.log("NITZ: Not setting clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                if (millisSinceNitzReceived < 0L) {
                    this.log("NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                    return;
                }
                if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                    this.log("NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                    return;
                }
                c.add(14, (int)millisSinceNitzReceived);
                if (this.getAutoTime()) {
                    long gained = c.getTimeInMillis() - System.currentTimeMillis();
                    long timeSinceLastUpdate = SystemClock.elapsedRealtime() - this.mSavedAtTime;
                    int nitzUpdateSpacing = Settings.Secure.getInt(this.cr, "nitz_update_spacing", this.mNitzUpdateSpacing);
                    int nitzUpdateDiff = Settings.Secure.getInt(this.cr, "nitz_update_diff", this.mNitzUpdateDiff);
                    if (this.mSavedAtTime == 0L || timeSinceLastUpdate > (long)nitzUpdateSpacing || Math.abs(gained) > (long)nitzUpdateDiff) {
                        this.log("NITZ: Auto updating time of day to " + c.getTime() + " NITZ receive delay=" + millisSinceNitzReceived + "ms gained=" + gained + "ms from " + nitz);
                        this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                    } else {
                        this.log("NITZ: ignore, a previous update was " + timeSinceLastUpdate + "ms ago and gained=" + gained + "ms");
                        return;
                    }
                }
                this.log("NITZ: update nitz time property");
                SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                this.mSavedTime = c.getTimeInMillis();
                this.mSavedAtTime = SystemClock.elapsedRealtime();
            }
            finally {
                long end = SystemClock.elapsedRealtime();
                this.log("NITZ: end=" + end + " dur=" + (end - start));
                this.mWakeLock.release();
            }
        }
        catch (RuntimeException ex) {
            this.loge("NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
        }
    }

    private boolean getAutoTime() {
        try {
            return Settings.System.getInt(this.cr, "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private boolean getAutoTimeZone() {
        try {
            return Settings.System.getInt(this.cr, "auto_time_zone") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        AlarmManager alarm = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", zoneId);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setAndBroadcastNetworkSetTime(long time) {
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", time);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void revertToNitzTime() {
        if (Settings.System.getInt(this.cr, "auto_time", 0) == 0) {
            return;
        }
        this.log("revertToNitzTime: mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
        }
    }

    private void revertToNitzTimeZone() {
        if (Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time_zone", 0) == 0) {
            return;
        }
        this.log("revertToNitzTimeZone: tz='" + this.mSavedTimeZone);
        if (this.mSavedTimeZone != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        }
    }

    protected boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHomeSid(int sid) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (sid != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        return false;
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    String getImsi() {
        String operatorNumeric = SystemProperties.get("gsm.sim.operator.numeric", "");
        if (!TextUtils.isEmpty(operatorNumeric) && this.getCdmaMin() != null) {
            return operatorNumeric + this.getCdmaMin();
        }
        return null;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    int getOtasp() {
        int provisioningState;
        if (this.mMin == null || this.mMin.length() < 6) {
            this.log("getOtasp: bad mMin='" + this.mMin + "'");
            provisioningState = 1;
        } else {
            provisioningState = this.mMin.equals(UNACTIVATED_MIN_VALUE) || this.mMin.substring(0, 6).equals(UNACTIVATED_MIN2_VALUE) || SystemProperties.getBoolean("test_cdma_setup", false) ? 2 : 3;
        }
        this.log("getOtasp: state=" + provisioningState);
        return provisioningState;
    }

    protected void hangupAndPowerOff() {
        this.phone.mCT.ringingCall.hangupIfAlive();
        this.phone.mCT.backgroundCall.hangupIfAlive();
        this.phone.mCT.foregroundCall.hangupIfAlive();
        this.cm.setRadioPower(false, null);
    }

    protected void parseSidNid(String sidStr, String nidStr) {
        int i;
        if (sidStr != null) {
            String[] sid = sidStr.split(",");
            this.mHomeSystemId = new int[sid.length];
            for (i = 0; i < sid.length; ++i) {
                try {
                    this.mHomeSystemId[i] = Integer.parseInt(sid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("error parsing system id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: SID=" + sidStr);
        if (nidStr != null) {
            String[] nid = nidStr.split(",");
            this.mHomeNetworkId = new int[nid.length];
            for (i = 0; i < nid.length; ++i) {
                try {
                    this.mHomeNetworkId[i] = Integer.parseInt(nid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("CDMA_SUBSCRIPTION: error parsing network id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: NID=" + nidStr);
    }

    protected void updateOtaspState() {
        int otaspMode = this.getOtasp();
        int oldOtaspMode = this.mCurrentOtaspMode;
        this.mCurrentOtaspMode = otaspMode;
        if (this.cdmaForSubscriptionInfoReadyRegistrants != null) {
            this.log("CDMA_SUBSCRIPTION: call notifyRegistrants()");
            this.cdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
        if (oldOtaspMode != this.mCurrentOtaspMode) {
            this.log("CDMA_SUBSCRIPTION: call notifyOtaspChanged old otaspMode=" + oldOtaspMode + " new otaspMode=" + this.mCurrentOtaspMode);
            this.phone.notifyOtaspChanged(this.mCurrentOtaspMode);
        }
    }

    protected void log(String s) {
        Log.d(LOG_TAG, "[CdmaSST] " + s);
    }

    protected void loge(String s) {
        Log.e(LOG_TAG, "[CdmaSST] " + s);
    }
}

