/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Environment;
import android.util.Log;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class VoiceMailConstants {
    private HashMap<String, String[]> CarrierVmMap = new HashMap();
    static final String LOG_TAG = "GSM";
    static final String PARTNER_VOICEMAIL_PATH = "etc/voicemail-conf.xml";
    static final int NAME = 0;
    static final int NUMBER = 1;
    static final int TAG = 2;
    static final int SIZE = 3;

    VoiceMailConstants() {
        this.loadVoiceMail();
    }

    boolean containsCarrier(String carrier) {
        return this.CarrierVmMap.containsKey(carrier);
    }

    String getCarrierName(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[0];
    }

    String getVoiceMailNumber(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[1];
    }

    String getVoiceMailTag(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[2];
    }

    private void loadVoiceMail() {
        FileReader vmReader;
        File vmFile = new File(Environment.getRootDirectory(), PARTNER_VOICEMAIL_PATH);
        try {
            vmReader = new FileReader(vmFile);
        }
        catch (FileNotFoundException e) {
            Log.w(LOG_TAG, "Can't open " + Environment.getRootDirectory() + "/" + PARTNER_VOICEMAIL_PATH);
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(vmReader);
            XmlUtils.beginDocument(parser, "voicemail");
            while (true) {
                XmlUtils.nextElement(parser);
                String name = parser.getName();
                if ("voicemail".equals(name)) {
                    String[] data = new String[3];
                    String numeric = parser.getAttributeValue(null, "numeric");
                    data[0] = parser.getAttributeValue(null, "carrier");
                    data[1] = parser.getAttributeValue(null, "vmnumber");
                    data[2] = parser.getAttributeValue(null, "vmtag");
                    this.CarrierVmMap.put(numeric, data);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            Log.w(LOG_TAG, "Exception in Voicemail parser " + e);
        }
        catch (IOException e) {
            Log.w(LOG_TAG, "Exception in Voicemail parser " + e);
        }
    }
}

