/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.Log;
import android.util.Slog;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.net.SocketException;

public class NetworkManagementSocketTagger
extends SocketTagger {
    private static final String TAG = "NetworkManagementSocketTagger";
    private static final boolean LOGD = false;
    public static final String PROP_QTAGUID_ENABLED = "net.qtaguid_enabled";
    private static ThreadLocal<SocketTags> threadSocketTags = new ThreadLocal<SocketTags>(){

        @Override
        protected SocketTags initialValue() {
            return new SocketTags();
        }
    };

    public static void install() {
        SocketTagger.set(new NetworkManagementSocketTagger());
    }

    public static void setThreadSocketStatsTag(int tag) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsTag = tag;
    }

    public static int getThreadSocketStatsTag() {
        return NetworkManagementSocketTagger.threadSocketTags.get().statsTag;
    }

    public static void setThreadSocketStatsUid(int uid) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsUid = uid;
    }

    public void tag(FileDescriptor fd) throws SocketException {
        SocketTags options = threadSocketTags.get();
        this.tagSocketFd(fd, options.statsTag, options.statsUid);
    }

    private void tagSocketFd(FileDescriptor fd, int tag, int uid) {
        if (tag == -1 && uid == -1) {
            return;
        }
        int errno = NetworkManagementSocketTagger.native_tagSocketFd(fd, tag, uid);
        if (errno < 0) {
            Log.i(TAG, "tagSocketFd(" + fd.getInt$() + ", " + tag + ", " + uid + ") failed with errno" + errno);
        }
    }

    public void untag(FileDescriptor fd) throws SocketException {
        this.unTagSocketFd(fd);
    }

    private void unTagSocketFd(FileDescriptor fd) {
        SocketTags options = threadSocketTags.get();
        if (options.statsTag == -1 && options.statsUid == -1) {
            return;
        }
        int errno = NetworkManagementSocketTagger.native_untagSocketFd(fd);
        if (errno < 0) {
            Log.w(TAG, "untagSocket(" + fd.getInt$() + ") failed with errno " + errno);
        }
    }

    public static void setKernelCounterSet(int uid, int counterSet) {
        int errno = NetworkManagementSocketTagger.native_setCounterSet(counterSet, uid);
        if (errno < 0) {
            Log.w(TAG, "setKernelCountSet(" + uid + ", " + counterSet + ") failed with errno " + errno);
        }
    }

    public static void resetKernelUidStats(int uid) {
        int errno = NetworkManagementSocketTagger.native_deleteTagData(0, uid);
        if (errno < 0) {
            Slog.w(TAG, "problem clearing counters for uid " + uid + " : errno " + errno);
        }
    }

    public static int kernelToTag(String string2) {
        return (int)(Long.decode(string2) >> 32);
    }

    private static int native_tagSocketFd(FileDescriptor fileDescriptor, int n, int n2) {
        return OverrideMethod.invokeI("com.android.server.NetworkManagementSocketTagger#native_tagSocketFd(Ljava/io/FileDescriptor;II)I", true, null);
    }

    private static int native_untagSocketFd(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("com.android.server.NetworkManagementSocketTagger#native_untagSocketFd(Ljava/io/FileDescriptor;)I", true, null);
    }

    private static int native_setCounterSet(int n, int n2) {
        return OverrideMethod.invokeI("com.android.server.NetworkManagementSocketTagger#native_setCounterSet(II)I", true, null);
    }

    private static int native_deleteTagData(int n, int n2) {
        return OverrideMethod.invokeI("com.android.server.NetworkManagementSocketTagger#native_deleteTagData(II)I", true, null);
    }

    public static class SocketTags {
        public int statsTag = -1;
        public int statsUid = -1;
    }
}

