/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteOrder;

public class Memory {
    private Memory() {
    }

    public static void unsafeBulkGet(Object object, int n, int n2, byte[] byArray, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#unsafeBulkGet(Ljava/lang/Object;II[BIIZ)V", true, null);
    }

    public static void unsafeBulkPut(byte[] byArray, int n, int n2, Object object, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#unsafeBulkPut([BIILjava/lang/Object;IIZ)V", true, null);
    }

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 24 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset] = (byte)(value >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            i = (int)value;
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value;
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset] = (byte)(value >> 8 & 0xFF);
        }
    }

    public static void memmove(Object object, int n, Object object2, int n2, long l) {
        OverrideMethod.invokeV("libcore.io.Memory#memmove(Ljava/lang/Object;ILjava/lang/Object;IJ)V", true, null);
    }

    public static byte peekByte(int n) {
        return (byte)OverrideMethod.invokeI("libcore.io.Memory#peekByte(I)B", true, null);
    }

    public static int peekInt(int n, boolean bl) {
        return OverrideMethod.invokeI("libcore.io.Memory#peekInt(IZ)I", true, null);
    }

    public static long peekLong(int n, boolean bl) {
        return OverrideMethod.invokeL("libcore.io.Memory#peekLong(IZ)J", true, null);
    }

    public static short peekShort(int n, boolean bl) {
        return (short)OverrideMethod.invokeI("libcore.io.Memory#peekShort(IZ)S", true, null);
    }

    public static void peekByteArray(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("libcore.io.Memory#peekByteArray(I[BII)V", true, null);
    }

    public static void peekCharArray(int n, char[] cArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekCharArray(I[CIIZ)V", true, null);
    }

    public static void peekDoubleArray(int n, double[] dArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekDoubleArray(I[DIIZ)V", true, null);
    }

    public static void peekFloatArray(int n, float[] fArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekFloatArray(I[FIIZ)V", true, null);
    }

    public static void peekIntArray(int n, int[] nArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekIntArray(I[IIIZ)V", true, null);
    }

    public static void peekLongArray(int n, long[] lArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekLongArray(I[JIIZ)V", true, null);
    }

    public static void peekShortArray(int n, short[] sArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekShortArray(I[SIIZ)V", true, null);
    }

    public static void pokeByte(int n, byte by) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeByte(IB)V", true, null);
    }

    public static void pokeInt(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeInt(IIZ)V", true, null);
    }

    public static void pokeLong(int n, long l, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeLong(IJZ)V", true, null);
    }

    public static void pokeShort(int n, short s, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeShort(ISZ)V", true, null);
    }

    public static void pokeByteArray(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeByteArray(I[BII)V", true, null);
    }

    public static void pokeCharArray(int n, char[] cArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeCharArray(I[CIIZ)V", true, null);
    }

    public static void pokeDoubleArray(int n, double[] dArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeDoubleArray(I[DIIZ)V", true, null);
    }

    public static void pokeFloatArray(int n, float[] fArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeFloatArray(I[FIIZ)V", true, null);
    }

    public static void pokeIntArray(int n, int[] nArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeIntArray(I[IIIZ)V", true, null);
    }

    public static void pokeLongArray(int n, long[] lArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeLongArray(I[JIIZ)V", true, null);
    }

    public static void pokeShortArray(int n, short[] sArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeShortArray(I[SIIZ)V", true, null);
    }
}

