/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator;

import com.morcinek.android.codegenerator.codegeneration.TemplateCodeGenerator;
import com.morcinek.android.codegenerator.extractor.ResourceExtractor;
import com.morcinek.android.codegenerator.extractor.model.Resource;
import com.morcinek.android.codegenerator.extractor.string.FileNameExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class CodeGenerator {
    private ResourceExtractor resourceExtractor;
    private FileNameExtractor fileNameExtractor;
    private TemplateCodeGenerator templateCodeGenerator;

    public CodeGenerator(ResourceExtractor resourceExtractor, FileNameExtractor fileNameExtractor, TemplateCodeGenerator templateCodeGenerator) {
        this.resourceExtractor = resourceExtractor;
        this.fileNameExtractor = fileNameExtractor;
        this.templateCodeGenerator = templateCodeGenerator;
    }

    public String produceCode(InputStream inputStream, String filePath) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        List<Resource> resources = this.resourceExtractor.extractResourceObjectsFromStream(inputStream);
        String filename = this.fileNameExtractor.extractFromString(filePath);
        return this.templateCodeGenerator.generateCode(resources, filename);
    }
}

