/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration;

import com.google.common.collect.Lists;
import com.morcinek.android.codegenerator.codegeneration.builders.BuildersCollection;
import com.morcinek.android.codegenerator.codegeneration.builders.CodeBuilder;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvidersFactory;
import com.morcinek.android.codegenerator.codegeneration.templates.TemplateManager;
import com.morcinek.android.codegenerator.codegeneration.templates.TemplatesProvider;
import com.morcinek.android.codegenerator.extractor.model.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCodeGenerator {
    private BuildersCollection buildersCollection;
    private ResourceProvidersFactory resourceProvidersFactory;
    private TemplateManager templateManager;

    public TemplateCodeGenerator(String templateName, ResourceProvidersFactory resourceProvidersFactory, TemplatesProvider templatesProvider) {
        this.resourceProvidersFactory = resourceProvidersFactory;
        this.buildersCollection = new BuildersCollection(templatesProvider);
        this.templateManager = new TemplateManager(templatesProvider.provideTemplateForName(templateName));
    }

    public String generateCode(List<Resource> resources, String fileName) {
        this.buildersCollection.registerCodeBuilders(this.getResourceProviders(resources), fileName);
        Map<String, CodeBuilder> builderMap = this.buildersCollection.getBuilderMap();
        for (String key : builderMap.keySet()) {
            this.templateManager.addTemplateValue(key, builderMap.get(key).builtString());
        }
        return this.templateManager.getResult();
    }

    private List<ResourceProvider> getResourceProviders(List<Resource> resources) {
        ArrayList resourceProviders = Lists.newArrayList();
        for (Resource resource : resources) {
            resourceProviders.add(this.resourceProvidersFactory.createResourceProvider(resource));
        }
        return resourceProviders;
    }
}

