/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration.builders;

import com.google.common.collect.Maps;
import com.morcinek.android.codegenerator.codegeneration.builders.CodeBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.file.ClassNameBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.file.ResourceNameBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.AssignmentsBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.FieldsBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.ImportsBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.InterfaceBuilder;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.MethodsBuilder;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.templates.TemplatesProvider;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildersCollection {
    private TemplatesProvider templatesProvider;
    private Map<String, CodeBuilder> builderMap = Maps.newHashMap();

    public BuildersCollection(TemplatesProvider templatesProvider) {
        this.templatesProvider = templatesProvider;
    }

    public Map<String, CodeBuilder> getBuilderMap() {
        return this.builderMap;
    }

    public void registerCodeBuilders(List<ResourceProvider> resourceProviders, String fileName) {
        this.registerCodeBuilder(this.builderMap, new ClassNameBuilder(fileName));
        this.registerCodeBuilder(this.builderMap, new ResourceNameBuilder(fileName));
        this.registerCodeBuilder(this.builderMap, new InterfaceBuilder(resourceProviders, this.templatesProvider));
        this.registerCodeBuilder(this.builderMap, new FieldsBuilder(resourceProviders, this.templatesProvider));
        this.registerCodeBuilder(this.builderMap, new AssignmentsBuilder(resourceProviders, this.templatesProvider));
        this.registerCodeBuilder(this.builderMap, new MethodsBuilder(resourceProviders, this.templatesProvider));
        this.registerCodeBuilder(this.builderMap, new ImportsBuilder(resourceProviders, this.templatesProvider));
    }

    private void registerCodeBuilder(Map<String, CodeBuilder> codeBuilderMap, CodeBuilder codeBuilder) {
        codeBuilderMap.put(codeBuilder.getKey(), codeBuilder);
    }
}

