/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration.builders.resources;

import com.google.common.collect.Maps;
import com.morcinek.android.codegenerator.codegeneration.builders.resources.ResourceCodeBuilder;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.templates.TemplateManager;
import com.morcinek.android.codegenerator.codegeneration.templates.TemplatesProvider;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsBuilder
extends ResourceCodeBuilder {
    private Map<String, StringBuilder> stringBuilders;

    public MethodsBuilder(List<ResourceProvider> resourceProviders, TemplatesProvider templatesProvider) {
        super(resourceProviders, templatesProvider);
    }

    @Override
    protected void initializeFields() {
        this.stringBuilders = Maps.newLinkedHashMap();
    }

    @Override
    protected void processResourceProvider(ResourceProvider resourceProvider) {
        if (resourceProvider.provideMethod() != null) {
            for (String method : resourceProvider.provideMethod()) {
                StringBuilder stringBuilder = this.getStringBuilder(method);
                TemplateManager templateManager = this.getTemplateManagerForMethodCase(method);
                templateManager.addTemplateValues(resourceProvider.provideValues());
                stringBuilder.append(templateManager.getResult());
            }
        }
    }

    private StringBuilder getStringBuilder(String method) {
        StringBuilder stringBuilder = this.stringBuilders.get(method);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            this.stringBuilders.put(method, stringBuilder);
        }
        return stringBuilder;
    }

    private TemplateManager getTemplateManagerForMethodCase(String method) {
        return new TemplateManager(this.templatesProvider.provideTemplateForName(method + "_Case_template"));
    }

    private TemplateManager getTemplateManagerForMethod(String method) {
        return new TemplateManager(this.templatesProvider.provideTemplateForName(method + "_template"));
    }

    @Override
    public String builtString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String method : this.stringBuilders.keySet()) {
            TemplateManager templateManager = this.getTemplateManagerForMethod(method);
            String methodCases = StringUtils.stripEnd((String)this.stringBuilders.get(method).toString(), null);
            templateManager.addTemplateValue("CASES", methodCases);
            stringBuilder.append(templateManager.getResult());
            stringBuilder.append("\n");
        }
        return this.prepareBuildString(stringBuilder.toString());
    }

    @Override
    public String getKey() {
        return "METHODS";
    }
}

