/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration.providers.factories;

import com.google.common.collect.Lists;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvidersFactory;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.ButtonProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.DefaultProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.GetterProvider;
import com.morcinek.android.codegenerator.extractor.model.Resource;

public class ActivityResourceProvidersFactory
implements ResourceProvidersFactory {
    public ResourceProvider createResourceProvider(Resource resource) {
        if (this.isApplicable(resource, "Button", "ImageButton")) {
            return new ButtonProvider(resource);
        }
        if (this.isApplicable(resource, "CheckBox", "EditText", "View")) {
            return new GetterProvider(resource);
        }
        return new DefaultProvider(resource);
    }

    private boolean isApplicable(Resource resource, String ... resourcesNames) {
        return Lists.newArrayList((Object[])resourcesNames).contains(resource.getResourceType().getFullName());
    }
}

