/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration.providers.factories;

import com.google.common.collect.Lists;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvidersFactory;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.AbstractResourceProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.ButtonProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.DefaultProvider;
import com.morcinek.android.codegenerator.codegeneration.providers.resources.GetterProvider;
import com.morcinek.android.codegenerator.extractor.model.Resource;

public class FragmentResourceProvidersFactory
implements ResourceProvidersFactory {
    public ResourceProvider createResourceProvider(Resource resource) {
        if (this.isApplicable(resource, "Button", "ImageButton")) {
            return this.getResourceProviderWithContainerPrefix(new ButtonProvider(resource), "view.");
        }
        if (this.isApplicable(resource, "CheckBox", "EditText", "View")) {
            return this.getResourceProviderWithContainerPrefix(new GetterProvider(resource), "getView().");
        }
        return this.getResourceProviderWithContainerPrefix(new DefaultProvider(resource), "view.");
    }

    private AbstractResourceProvider getResourceProviderWithContainerPrefix(AbstractResourceProvider resourceProvider, String value) {
        resourceProvider.putExtra("CONTAINER_PREFIX", value);
        return resourceProvider;
    }

    private boolean isApplicable(Resource resource, String ... resourcesNames) {
        return Lists.newArrayList((Object[])resourcesNames).contains(resource.getResourceType().getFullName());
    }
}

