/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.codegeneration.providers.resources;

import com.google.common.collect.Maps;
import com.morcinek.android.codegenerator.codegeneration.providers.ResourceProvider;
import com.morcinek.android.codegenerator.extractor.model.Resource;
import com.morcinek.android.codegenerator.extractor.model.ResourceId;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceProvider
implements ResourceProvider {
    private final Map<String, String> values;

    protected AbstractResourceProvider(Resource resource) {
        this.values = this.createValues(resource);
    }

    @Override
    public Map<String, String> provideValues() {
        return this.values;
    }

    public void putExtra(String key, String value) {
        this.values.put(key, value);
    }

    private Map<String, String> createValues(Resource resource) {
        HashMap values = Maps.newHashMap();
        values.put("RESOURCE_ID", this.getResourceId(resource));
        values.put("RESOURCE_TYPE", resource.getResourceType().getClassName());
        values.put("RESOURCE_NAME", this.getResourceName(resource));
        values.put("RESOURCE_NAME_CAPITALIZED", StringUtils.capitalize((String)this.getResourceName(resource)));
        values.put("RESOURCE_PACKAGE", this.getPackageName(resource));
        return values;
    }

    private String getResourceName(Resource resource) {
        String idName = resource.getResourceId().getName();
        StringBuilder stringBuilder = new StringBuilder();
        for (String word : idName.split("_")) {
            stringBuilder.append(StringUtils.capitalize((String)word));
        }
        return StringUtils.uncapitalize((String)stringBuilder.toString());
    }

    private String getResourceId(Resource resource) {
        ResourceId resourceId = resource.getResourceId();
        if (resourceId.getNamespace() != null) {
            return resourceId.getNamespace().concat(".R.id.").concat(resourceId.getName());
        }
        return "R.id." + resourceId.getName();
    }

    private String getPackageName(Resource resource) {
        String packageName = resource.getResourceType().getPackageName();
        if (packageName == null) {
            if (resource.getResourceType().getClassName().equals("View")) {
                return "android.view";
            }
            return "android.widget";
        }
        return packageName;
    }
}

