/*
 * Decompiled with CFR 0.152.
 */
package com.morcinek.android.codegenerator.extractor.string;

import com.morcinek.android.codegenerator.extractor.model.ResourceId;
import com.morcinek.android.codegenerator.extractor.string.StringExtractor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIdExtractor
implements StringExtractor<ResourceId> {
    @Override
    public ResourceId extractFromString(String idAttribute) {
        IdAttributeUnion attributeUnion = new IdAttributeUnion(idAttribute);
        return new ResourceId(attributeUnion.name, this.getNamespace(attributeUnion.prefix));
    }

    private String getNamespace(String prefix) {
        Matcher matcher = Pattern.compile("@([\\w]+):id").matcher(prefix);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private class IdAttributeUnion {
        String prefix;
        String name;

        IdAttributeUnion(String idAttribute) {
            String[] split = idAttribute.split("\\/");
            this.prefix = split[0];
            this.name = split[1];
        }
    }
}

