/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.PsiFileAndLineNavigation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class EditMultipleSourcesAction
extends AnAction {
    public EditMultipleSourcesAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(ActionsBundle.actionText((String)"EditSource"));
        presentation.setIcon(AllIcons.Actions.EditSource);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Navigatable[] navigatables = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        e.getPresentation().setEnabled(navigatables != null && navigatables.length > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        final Navigatable[] files = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        assert (files != null && files.length > 0);
        if (files.length > 1) {
            DefaultListModel<PsiFile> listModel = new DefaultListModel<PsiFile>();
            for (int i = 0; i < files.length; ++i) {
                assert (files[i] instanceof PsiFileAndLineNavigation);
                listModel.add(i, ((PsiFileAndLineNavigation)files[i]).getPsiFile());
            }
            final JBList list = new JBList(listModel);
            int width = WindowManager.getInstance().getFrame((Project)project).getSize().width;
            list.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Target File").setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object selectedValue = list.getSelectedValue();
                    PsiFileAndLineNavigation navigationWrapper = null;
                    for (int i = 0; i < files.length; ++i) {
                        if (selectedValue != ((PsiFileAndLineNavigation)files[i]).getPsiFile()) continue;
                        navigationWrapper = (PsiFileAndLineNavigation)files[i];
                        break;
                    }
                    assert (navigationWrapper != null);
                    if (navigationWrapper.canNavigate()) {
                        navigationWrapper.navigate(true);
                    }
                }
            }).createPopup();
            InputEvent event = e.getInputEvent();
            if (event instanceof MouseEvent) {
                Point location = ((MouseEvent)event).getPoint();
                Component owner = e.getInputEvent().getComponent();
                SwingUtilities.convertPointToScreen(location, owner);
                popup.showInScreenCoordinates(owner, location);
            } else {
                popup.showInFocusCenter();
            }
        } else {
            assert (files[0] instanceof PsiFileAndLineNavigation);
            PsiFileAndLineNavigation file = (PsiFileAndLineNavigation)files[0];
            if (file.canNavigate()) {
                file.navigate(true);
            }
        }
    }
}

