/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileAndLineNavigation
implements NavigationItem {
    @NotNull
    private PsiFile myPsiFile;
    private int myLineNumber;

    public PsiFileAndLineNavigation(@NotNull PsiFile file, int lineNumber) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/PsiFileAndLineNavigation", "<init>"));
        }
        this.myPsiFile = file;
        this.myLineNumber = lineNumber;
    }

    @Nullable
    public static PsiFileAndLineNavigation[] wrappersForClassName(@NotNull Project project, @Nullable String className, int lineNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/PsiFileAndLineNavigation", "wrappersForClassName"));
        }
        if (className != null) {
            PsiClass[] classes;
            ArrayList<PsiFileAndLineNavigation> files = new ArrayList<PsiFileAndLineNavigation>();
            for (PsiClass c : classes = JavaPsiFacade.getInstance((Project)project).findClasses(className, GlobalSearchScope.allScope((Project)project))) {
                files.add(new PsiFileAndLineNavigation((PsiFile)c.getContainingFile().getNavigationElement(), lineNumber));
            }
            return files.toArray(new PsiFileAndLineNavigation[files.size()]);
        }
        return null;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiFileAndLineNavigation", "getPsiFile"));
        }
        return psiFile;
    }

    @Nullable
    public String getName() {
        return this.myPsiFile.getName();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this.myPsiFile.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myLineNumber);
        fileDescriptor.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myPsiFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myPsiFile.canNavigateToSource();
    }
}

