/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingProjectComponent
implements ProjectComponent,
ModificationTracker {
    final CachedValue<AndroidFacet[]> myDataBindingEnabledModules;
    final Project myProject;
    private AtomicLong myModificationCount = new AtomicLong(0L);
    private Map<String, PsiPackage> myDataBindingPsiPackages = Maps.newConcurrentMap();

    public DataBindingProjectComponent(Project project) {
        this.myProject = project;
        this.myDataBindingEnabledModules = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<AndroidFacet[]>(){

            @Nullable
            public CachedValueProvider.Result<AndroidFacet[]> compute() {
                Module[] modules = ModuleManager.getInstance((Project)DataBindingProjectComponent.this.myProject).getModules();
                ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
                for (Module module : modules) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || !facet.isDataBindingEnabled()) continue;
                    facets.add(facet);
                }
                DataBindingProjectComponent.this.myModificationCount.incrementAndGet();
                return CachedValueProvider.Result.create((Object)facets.toArray(new AndroidFacet[facets.size()]), (Object[])new Object[]{DataBindingUtil.DATA_BINDING_ENABLED_TRACKER});
            }
        }, false);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingProjectComponent", "getProject"));
        }
        return project;
    }

    public boolean hasAnyDataBindingEnabledFacet() {
        return this.getDataBindingEnabledFacets().length > 0;
    }

    public AndroidFacet[] getDataBindingEnabledFacets() {
        return (AndroidFacet[])this.myDataBindingEnabledModules.getValue();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("data binding project component" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingProjectComponent", "getComponentName"));
        }
        return "data binding project component";
    }

    public long getModificationCount() {
        return this.myModificationCount.longValue();
    }

    public synchronized PsiPackage getOrCreateDataBindingPsiPackage(String packageName) {
        Object pkg = this.myDataBindingPsiPackages.get(packageName);
        if (pkg == null) {
            pkg = new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), packageName){

                public boolean isValid() {
                    return true;
                }
            };
            this.myDataBindingPsiPackages.put(packageName, (PsiPackage)pkg);
        }
        return pkg;
    }
}

