/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidIcons;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleAllocationTrackingAction
extends ToggleAction {
    private final DeviceContext myDeviceContext;
    private final EventData myEvents;
    private EventData.Event myEvent;

    public ToggleAllocationTrackingAction(@NotNull DeviceContext context, EventData events) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        super(AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), null, AndroidIcons.Ddms.AllocationTracker);
        this.myDeviceContext = context;
        this.myEvents = events;
    }

    public boolean isSelected(AnActionEvent e) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return false;
        }
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
            if (this.myEvent == null) {
                this.myEvent = this.myEvents.start(now, 2);
            }
            this.myEvent.stop(now);
            this.myEvent = null;
        } else {
            c.enableAllocationTracker(true);
            if (this.myEvent != null) {
                this.myEvent.stop(now);
            }
            this.myEvent = this.myEvents.start(now, 2);
        }
        c.requestAllocationStatus();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            presentation.setEnabled(false);
            return;
        }
        String text = c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
        presentation.setText(text);
        presentation.setEnabled(true);
    }
}

