/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectResourceIdResolver
implements ResourceIdResolver {
    private final Project myProject;
    private TIntObjectHashMap<String> myIdMap;
    private boolean myInitialized;

    @NotNull
    public static ResourceIdResolver getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/debug/ProjectResourceIdResolver", "getInstance"));
        }
        ResourceIdResolver resourceIdResolver = (ResourceIdResolver)ServiceManager.getService((Project)project, ResourceIdResolver.class);
        if (resourceIdResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/debug/ProjectResourceIdResolver", "getInstance"));
        }
        return resourceIdResolver;
    }

    private ProjectResourceIdResolver(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/debug/ProjectResourceIdResolver", "<init>"));
        }
        this.myProject = project;
    }

    @Override
    @Nullable
    public String getAndroidResourceName(int resId) {
        if (!this.myInitialized) {
            this.myIdMap = this.getIdMap();
            this.myInitialized = true;
        }
        return this.myIdMap == null ? null : (String)this.myIdMap.get(resId);
    }

    private TIntObjectHashMap<String> getIdMap() {
        AndroidSdkData sdkData;
        Module m;
        AndroidFacet facet = null;
        Module[] arr$ = ModuleManager.getInstance((Project)this.myProject).getModules();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (facet = AndroidFacet.getInstance(m = arr$[i$])) == null; ++i$) {
        }
        AndroidSdkData androidSdkData = sdkData = facet == null ? null : facet.getSdkData();
        if (sdkData == null) {
            return null;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            return null;
        }
        return sdkData.getTargetData(targets[targets.length - 1]).getPublicIdMap();
    }
}

