/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnimportedModuleNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    public static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.module.import");
    @NotNull
    private final Project myProject;
    private final AtomicBoolean myIsImporting;

    public UnimportedModuleNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider", "<init>"));
        }
        this.myIsImporting = new AtomicBoolean(false);
        this.myProject = project;
    }

    private static boolean isImportedGradleProjectRoot(VirtualFile file, Project myProject) {
        VirtualFile buildFile;
        IdeaGradleProject gradleProject;
        AndroidGradleFacet facet;
        VirtualFile parent = file.getParent();
        if (parent.equals(myProject.getBaseDir())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)myProject);
        return module != null && (facet = AndroidGradleFacet.getInstance(module)) != null && (gradleProject = facet.getGradleProject()) != null && (buildFile = gradleProject.getBuildFile()) != null && file.getParent().equals(parent);
    }

    private static boolean isGradleBuildFile(VirtualFile file) {
        return ImmutableSet.of((Object)"build.gradle", (Object)"settings.gradle").contains((Object)file.getName());
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider", "createNotificationPanel"));
        }
        if (!Projects.isGradleProject(this.myProject) || this.myIsImporting.get()) {
            return null;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (Projects.lastGradleSyncFailed(this.myProject) || syncState.isSyncInProgress() || syncState.isSyncNeeded() != ThreeState.NO) {
            return null;
        }
        if (!UnimportedModuleNotificationProvider.isGradleBuildFile(file) || UnimportedModuleNotificationProvider.isImportedGradleProjectRoot(file, this.myProject)) {
            return null;
        }
        return new UnimportedModuleNotificationPanel(this.myProject, file.getParent());
    }

    private class UnimportedModuleNotificationPanel
    extends EditorNotificationPanel {
        public UnimportedModuleNotificationPanel(final @NotNull Project project, final VirtualFile subproject) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider$UnimportedModuleNotificationPanel", "<init>"));
            }
            if (subproject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subproject", "com/android/tools/idea/editors/UnimportedModuleNotificationProvider$UnimportedModuleNotificationPanel", "<init>"));
            }
            this.setText("This folder does not belong to a Gradle project. Make sure it is registered in settings.gradle.");
            this.createActionLabel("Add Now...", new Runnable(){

                @Override
                public void run() {
                    UnimportedModuleNotificationProvider.this.myIsImporting.set(true);
                    try {
                        AndroidImportModuleAction.importGradleSubprojectAsModule(subproject, project);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    finally {
                        UnimportedModuleNotificationProvider.this.myIsImporting.set(false);
                    }
                }
            });
        }
    }
}

