/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.rpc.Capture;
import com.android.tools.idea.editors.gfxtrace.rpc.CaptureId;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.Device;
import com.android.tools.idea.editors.gfxtrace.rpc.DeviceId;
import com.android.tools.rpclib.binary.Handle;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.primitives.Ints;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashMap;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextController {
    private static final String NO_DEVICE_AVAILABLE = "No Device Available";
    private static final String NO_DEVICE_SELECTED = "No Device Selected";
    private static final String NO_CAPTURE_AVAILABLE = "No Capture Available";
    private static final String NO_CAPTURE_SELECTED = "No Capture Selected";
    @NotNull
    private static final Logger LOG = Logger.getInstance(ContextController.class);
    @NotNull
    private final GfxTraceEditor myEditor;
    @NotNull
    private final ComboBox myDevicesView;
    @NotNull
    private final ComboBox myCapturesView;
    @NotNull
    private final ComboBox myGfxContextsView;
    @Nullable
    private Device myCurrentDevice;
    @Nullable
    private Capture myCurrentCapture;
    @Nullable
    private volatile Integer myCurrentContext;
    @NotNull
    private Map<Device, DeviceId> myDevices;
    @NotNull
    private Map<Capture, CaptureId> myCaptures;
    @NotNull
    private AtomicBoolean myShouldStopContextSwitch;

    public ContextController(@NotNull GfxTraceEditor editor, @NotNull ComboBox devicesView, @NotNull ComboBox capturesView, @NotNull ComboBox gfxContextsView) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        if (devicesView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devicesView", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        if (capturesView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturesView", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        if (gfxContextsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gfxContextsView", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        this.myDevices = new HashMap();
        this.myCaptures = new HashMap();
        this.myShouldStopContextSwitch = new AtomicBoolean(false);
        this.myEditor = editor;
        this.myDevicesView = devicesView;
        this.myCapturesView = capturesView;
        this.myGfxContextsView = gfxContextsView;
        this.myDevicesView.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Device>(){

            public void customize(JList list, Device value, int index, boolean selected, boolean hasFocus) {
                if (list.getModel().getSize() == 0) {
                    this.setText(ContextController.NO_DEVICE_AVAILABLE);
                } else if (index == -1 && ContextController.this.myCurrentDevice == null) {
                    this.setText(ContextController.NO_DEVICE_SELECTED);
                } else {
                    this.setText(value.getName() + " (" + value.getModel() + ", " + value.getOS() + ")");
                }
            }
        });
        this.myCapturesView.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Capture>(){

            public void customize(JList list, Capture value, int index, boolean selected, boolean hasFocus) {
                if (list.getModel().getSize() == 0) {
                    this.setText(ContextController.NO_CAPTURE_AVAILABLE);
                } else if (index == -1) {
                    if (ContextController.this.myCurrentCapture == null) {
                        this.setText(ContextController.NO_CAPTURE_SELECTED);
                    } else {
                        this.setText(ContextController.this.myCurrentCapture.getName());
                    }
                } else {
                    this.setText(((Capture)list.getModel().getElementAt(index)).getName());
                }
            }
        });
    }

    @Nullable
    public Device getCurrentDevice() {
        return this.myCurrentDevice;
    }

    @NotNull
    public DeviceId getCurrentDeviceId() {
        DeviceId deviceId = this.myDevices.get(this.myCurrentDevice);
        if (deviceId == null) {
            throw new RuntimeException("DeviceId not found!");
        }
        DeviceId deviceId2 = deviceId;
        if (deviceId2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getCurrentDeviceId"));
        }
        return deviceId2;
    }

    @Nullable
    public Capture getCurrentCapture() {
        return this.myCurrentCapture;
    }

    @NotNull
    public CaptureId getCurrentCaptureId() {
        CaptureId captureId = this.myCaptures.get(this.myCurrentCapture);
        if (captureId == null) {
            throw new RuntimeException("CaptureId not found!");
        }
        CaptureId captureId2 = captureId;
        if (captureId2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getCurrentCaptureId"));
        }
        return captureId2;
    }

    @Nullable
    public Integer getCurrentContext() {
        return this.myCurrentContext;
    }

    public void initialize() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Future<DeviceId[]> deviceFuture;
                    DeviceId[] tempDeviceIds;
                    Client client = ContextController.this.myEditor.getClient();
                    Future<CaptureId[]> captureFuture = client.GetCaptures();
                    final CaptureId[] captureIds = captureFuture.get();
                    while ((tempDeviceIds = (deviceFuture = client.GetDevices()).get()).length <= 0) {
                        Thread.sleep(200L);
                    }
                    final DeviceId[] deviceIds = tempDeviceIds;
                    final ArrayList<Capture> captures = new ArrayList<Capture>(captureIds.length);
                    final ArrayList<Device> devices = new ArrayList<Device>(deviceIds.length);
                    for (CaptureId captureId : captureIds) {
                        Capture capture = client.ResolveCapture(captureId).get();
                        captures.add(capture);
                    }
                    for (Handle handle : deviceIds) {
                        Device device = client.ResolveDevice((DeviceId)handle).get();
                        devices.add(device);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ContextController.this.updateCaptureList(captureIds, captures);
                            ContextController.this.myCurrentCapture = null;
                            ContextController.this.updateAvailableDevices(deviceIds, devices, ContextController.this.myCurrentDevice);
                            ContextController.this.getDevicesView().addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent itemEvent) {
                                    if (itemEvent.getStateChange() == 1) {
                                        if (itemEvent.getItem() instanceof Device) {
                                            Device selectedDevice = (Device)itemEvent.getItem();
                                            ContextController.this.selectDevice(selectedDevice);
                                            ContextController.this.myEditor.notifyDeviceChanged(selectedDevice);
                                        } else {
                                            ContextController.this.myCurrentDevice = null;
                                        }
                                    }
                                }
                            });
                            ContextController.this.getCapturesView().addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent itemEvent) {
                                    if (itemEvent.getStateChange() == 1) {
                                        assert (itemEvent.getItem() instanceof Capture);
                                        Capture selectedCapture = (Capture)itemEvent.getItem();
                                        ContextController.this.selectCapture(selectedCapture);
                                        ContextController.this.myEditor.notifyCaptureChanged(selectedCapture);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (RpcException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public void populateUi(@NotNull int[] contextIds) {
        if (contextIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextIds", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "populateUi"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateGfxContextView(contextIds);
        this.setGfxContext(contextIds[0]);
        this.getGfxContextsView().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Integer newContext = (Integer)itemEvent.getItem();
                    assert (!newContext.equals(ContextController.this.myCurrentContext));
                    ContextController.this.myCurrentContext = newContext;
                    assert (ContextController.this.myCurrentContext != null);
                    ContextController.this.setGfxContext(ContextController.this.myCurrentContext);
                }
            }
        });
    }

    private void updateAvailableDevices(@NotNull DeviceId[] deviceIds, @NotNull List<Device> devices, @Nullable Device previouslySelected) {
        if (deviceIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceIds", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateAvailableDevices"));
        }
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateAvailableDevices"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateDeviceList(deviceIds, devices);
        if (devices.size() > 0) {
            Device deviceToSelect = devices.get(0);
            if (previouslySelected != null && devices.contains(previouslySelected)) {
                deviceToSelect = previouslySelected;
            }
            this.selectDevice(deviceToSelect);
            this.myEditor.notifyDeviceChanged(deviceToSelect);
        }
    }

    private void selectDevice(@NotNull Device selectedDevice) {
        if (selectedDevice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedDevice", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "selectDevice"));
        }
        assert (this.myCurrentDevice != selectedDevice);
        this.myCurrentDevice = selectedDevice;
    }

    private void selectCapture(@NotNull Capture selectedCapture) {
        if (selectedCapture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedCapture", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "selectCapture"));
        }
        assert (selectedCapture != this.myCurrentCapture);
        this.myCurrentCapture = selectedCapture;
        this.myCurrentContext = null;
        this.clearGfxContextView();
    }

    private void setGfxContext(@NotNull Integer contextId) {
        if (contextId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextId", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "setGfxContext"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myShouldStopContextSwitch.get() && contextId.equals(this.myCurrentContext)) {
            return;
        }
        this.myShouldStopContextSwitch.set(true);
        this.myShouldStopContextSwitch = new AtomicBoolean(false);
        this.myCurrentContext = contextId;
        this.myEditor.resolveGfxContextChange(this.myShouldStopContextSwitch);
    }

    @NotNull
    private ComboBox getDevicesView() {
        ComboBox comboBox = this.myDevicesView;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getDevicesView"));
        }
        return comboBox;
    }

    @NotNull
    private ComboBox getCapturesView() {
        ComboBox comboBox = this.myCapturesView;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getCapturesView"));
        }
        return comboBox;
    }

    @NotNull
    private ComboBox getGfxContextsView() {
        ComboBox comboBox = this.myGfxContextsView;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getGfxContextsView"));
        }
        return comboBox;
    }

    private void updateDeviceList(@NotNull DeviceId[] deviceIds, @NotNull List<Device> devices) {
        if (deviceIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceIds", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateDeviceList"));
        }
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateDeviceList"));
        }
        this.myDevices.clear();
        for (int i = 0; i < deviceIds.length; ++i) {
            this.myDevices.put(devices.get(i), deviceIds[i]);
        }
        this.getDevicesView().setModel(new DefaultComboBoxModel<Object>(devices.toArray()));
    }

    private void updateCaptureList(@NotNull CaptureId[] captureIds, @NotNull List<Capture> captures) {
        if (captureIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureIds", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateCaptureList"));
        }
        if (captures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captures", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateCaptureList"));
        }
        this.myCaptures.clear();
        for (int i = 0; i < captureIds.length; ++i) {
            this.myCaptures.put(captures.get(i), captureIds[i]);
        }
        this.myCapturesView.setModel(new DefaultComboBoxModel<Object>(captures.toArray()));
        this.myCapturesView.setSelectedIndex(-1);
    }

    private void updateGfxContextView(@NotNull int[] contextList) {
        if (contextList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextList", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "updateGfxContextView"));
        }
        assert (contextList.length > 0);
        Object[] boxedContextList = Ints.asList((int[])contextList).toArray();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(boxedContextList);
        this.myGfxContextsView.setModel(model);
        this.myGfxContextsView.setSelectedIndex(0);
    }

    private void clearGfxContextView() {
        this.getGfxContextsView().setModel(new DefaultComboBoxModel<Object>(ArrayUtil.EMPTY_OBJECT_ARRAY));
    }
}

