/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers.modeldata;

import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.AtomTreeNode;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.EnumInfoCache;
import com.android.tools.idea.editors.gfxtrace.rpc.ParameterInfo;
import com.android.tools.idea.editors.gfxtrace.schema.Atom;
import com.android.tools.idea.editors.gfxtrace.schema.AtomReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleTextAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class AtomNode
extends AtomTreeNode {
    @NotNull
    private static final Logger LOG = Logger.getInstance(AtomNode.class);
    private long myId;

    public AtomNode(long id) {
        this.myId = id;
    }

    public long getRepresentativeAtomId() {
        return this.myId;
    }

    @Override
    public List<AtomTreeNode.TextPiece> getTextPieces(@NotNull JTree tree, @NotNull TreeNode node, @NotNull EnumInfoCache enumInfoCache, @NotNull AtomReader atomReader) {
        Atom atom;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/gfxtrace/controllers/modeldata/AtomNode", "getTextPieces"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/controllers/modeldata/AtomNode", "getTextPieces"));
        }
        if (enumInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumInfoCache", "com/android/tools/idea/editors/gfxtrace/controllers/modeldata/AtomNode", "getTextPieces"));
        }
        if (atomReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomReader", "com/android/tools/idea/editors/gfxtrace/controllers/modeldata/AtomNode", "getTextPieces"));
        }
        try {
            atom = atomReader.read(this.myId);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<AtomTreeNode.TextPiece> textPieces = new ArrayList<AtomTreeNode.TextPiece>();
        textPieces.add(new AtomTreeNode.TextPiece(Long.toString(this.myId) + "   ", SimpleTextAttributes.REGULAR_ATTRIBUTES));
        textPieces.add(new AtomTreeNode.TextPiece(atom.info.getName() + "(", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        block5: for (int i = 0; i < atom.info.getParameters().length; ++i) {
            if (i != 0) {
                textPieces.add(new AtomTreeNode.TextPiece(", ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
            }
            ParameterInfo parameterInfo = atom.info.getParameters()[i];
            Object parameterValue = atom.parameters[i].value;
            switch (parameterInfo.getType().getKind()) {
                case Enum: {
                    textPieces.add(new AtomTreeNode.TextPiece(parameterValue.toString(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES));
                    continue block5;
                }
                default: {
                    textPieces.add(new AtomTreeNode.TextPiece(atom.parameters[i].value.toString(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES));
                }
            }
        }
        textPieces.add(new AtomTreeNode.TextPiece(")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        return textPieces;
    }
}

