/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.schema;

import com.android.tools.idea.editors.gfxtrace.rpc.ArrayInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.ClassInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.EnumInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.FieldInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.MapInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.StructInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.TypeInfo;
import com.android.tools.idea.editors.gfxtrace.schema.Array;
import com.android.tools.idea.editors.gfxtrace.schema.Class;
import com.android.tools.idea.editors.gfxtrace.schema.EnumValue;
import com.android.tools.idea.editors.gfxtrace.schema.Field;
import com.android.tools.idea.editors.gfxtrace.schema.Map;
import com.android.tools.idea.editors.gfxtrace.schema.MapEntry;
import com.android.tools.idea.editors.gfxtrace.schema.Struct;
import com.android.tools.rpclib.binary.Decoder;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class Unpack {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)Unpack.class.getName());

    public static Object Type(TypeInfo type, Decoder decoder) throws IOException {
        switch (type.getKind()) {
            case Bool: {
                return decoder.bool();
            }
            case S8: {
                return decoder.int8();
            }
            case U8: {
                return decoder.uint8();
            }
            case S16: {
                return decoder.int16();
            }
            case U16: {
                return decoder.uint16();
            }
            case S32: {
                return decoder.int32();
            }
            case U32: {
                return decoder.uint32();
            }
            case F32: {
                return Float.valueOf(decoder.float32());
            }
            case S64: {
                return decoder.int64();
            }
            case U64: {
                return decoder.uint64();
            }
            case F64: {
                return decoder.float64();
            }
            case String: {
                return decoder.string();
            }
            case Enum: {
                EnumInfo info = (EnumInfo)type;
                return new EnumValue(info, decoder.uint32());
            }
            case Struct: {
                StructInfo info = (StructInfo)type;
                Field[] fields = new Field[info.getFields().length];
                for (int i = 0; i < info.getFields().length; ++i) {
                    FieldInfo fieldInfo = info.getFields()[i];
                    Object value = Unpack.Type(fieldInfo.getType(), decoder);
                    fields[i] = new Field(fieldInfo, value);
                }
                return new Struct(info, fields);
            }
            case Class: {
                ClassInfo info = (ClassInfo)type;
                Field[] fields = new Field[info.getFields().length];
                for (int i = 0; i < info.getFields().length; ++i) {
                    FieldInfo fieldInfo = info.getFields()[i];
                    Object value = Unpack.Type(fieldInfo.getType(), decoder);
                    fields[i] = new Field(fieldInfo, value);
                }
                return new Class(info, fields);
            }
            case Array: {
                ArrayInfo info = (ArrayInfo)type;
                int count = decoder.int32();
                Object[] elements = new Object[count];
                for (int i = 0; i < count; ++i) {
                    elements[i] = Unpack.Type(info.getElementType(), decoder);
                }
                return new Array(info, elements);
            }
            case Map: {
                MapInfo info = (MapInfo)type;
                int count = decoder.int32();
                MapEntry[] elements = new MapEntry[count];
                for (int i = 0; i < count; ++i) {
                    Object key = Unpack.Type(info.getKeyType(), decoder);
                    Object value = Unpack.Type(info.getValueType(), decoder);
                    elements[i] = new MapEntry(key, value);
                }
                return new Map(info, elements);
            }
            case Pointer: {
                return decoder.uint64();
            }
            case Memory: {
                return "<Memory>";
            }
            case Any: {
                LOG.error("'Any' type not yet implemented.");
                return "";
            }
            case ID: {
                byte[] b = new byte[20];
                decoder.read(b, 20);
                return b;
            }
        }
        throw new RuntimeException("Unknown kind " + (Object)((Object)type.getKind()));
    }
}

