/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.descriptors;

import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.jdi.ArrayReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ClassObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.StringReferenceImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceFieldDescriptorImpl
extends HprofFieldDescriptorImpl {
    private static final int MAX_VALUE_TEXT_LENGTH = 1024;
    @NotNull
    private ObjectReferenceImpl myObjectReference;
    @Nullable
    private String myTruncatedValueText;

    public InstanceFieldDescriptorImpl(@NotNull Project project, @NotNull Field field, @Nullable Instance instance, int memoryOrdering) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "<init>"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "<init>"));
        }
        super(project, field, instance, memoryOrdering);
        this.myObjectReference = this.initObjectReference();
    }

    @Nullable
    public Instance getInstance() {
        return (Instance)this.myValueData;
    }

    public boolean isString() {
        return this.myValueData != null && ((Instance)this.myValueData).getClassObj() != null && "java.lang.String".equals(((Instance)this.myValueData).getClassObj().getClassName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isExpandable() {
        if (this.myValueData instanceof ClassObj) {
            return false;
        }
        if (this.myValueData instanceof ArrayInstance) {
            return ((ArrayInstance)this.myValueData).getSize() > 0;
        }
        return !this.isNull();
    }

    @Override
    public Value getValue() {
        return this.calcValue(null);
    }

    @NotNull
    public String getIdLabel() {
        if (this.myValueData == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "getIdLabel"));
            }
            return "";
        }
        String string = ValueDescriptorImpl.getIdLabel((ObjectReference)this.myObjectReference);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "getIdLabel"));
        }
        return string;
    }

    @NotNull
    public String getValueText() {
        if (this.myTruncatedValueText != null) {
            String string = this.myTruncatedValueText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "getValueText"));
            }
            return string;
        }
        if (this.myValueData == null) {
            this.myTruncatedValueText = "null";
        } else if (this.myValueData instanceof ClassObj) {
            this.myTruncatedValueText = String.format(" \"class %s\"", ((ClassObj)this.myValueData).getClassName());
        } else if (this.isString()) {
            ArrayInstance charBufferArray = null;
            assert (this.myValueData instanceof ClassInstance);
            ClassInstance classInstance = (ClassInstance)this.myValueData;
            for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                if (!"value".equals(entry.getField().getName())) continue;
                charBufferArray = (ArrayInstance)entry.getValue();
            }
            assert (charBufferArray != null);
            char[] stringChars = charBufferArray.asCharArray(1024);
            int charLength = stringChars.length;
            StringBuilder builder = new StringBuilder(6 + charLength);
            builder.append(" \"");
            if (charLength == 1024) {
                builder.append(stringChars, 0, charLength - 1).append("...");
            } else {
                builder.append(stringChars);
            }
            builder.append("\"");
            this.myTruncatedValueText = builder.toString();
        } else {
            this.myTruncatedValueText = "";
        }
        String string = this.myTruncatedValueText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl", "getValueText"));
        }
        return string;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) {
        return this.myObjectReference;
    }

    private ObjectReferenceImpl initObjectReference() {
        if (this.isString()) {
            return new StringReferenceImpl(this.myField, (Instance)this.myValueData);
        }
        if (this.myValueData instanceof ArrayInstance) {
            return new ArrayReferenceImpl(this.myField, (Instance)((ArrayInstance)this.myValueData));
        }
        if (this.myValueData instanceof ClassObj) {
            return new ClassObjectReferenceImpl(this.myField, (Instance)((ClassObj)this.myValueData));
        }
        return new ObjectReferenceImpl(this.myField, (Instance)this.myValueData);
    }
}

