/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.tables;

import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.descriptors.ContainerDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.ExpansionDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.InstanceFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.PrimitiveFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.tables.SelectionModel;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstancesTree {
    private static final int NODES_PER_EXPANSION = 100;
    @NotNull
    private DebuggerTree myDebuggerTree;
    @NotNull
    private JComponent myColumnTree;
    @NotNull
    private DebugProcessImpl myDebugProcess;
    @NotNull
    private volatile SuspendContextImpl myDummySuspendContext;
    @NotNull
    private Heap myHeap;
    @Nullable
    private ClassObj myClassObj;
    @Nullable
    private Comparator<DebuggerTreeNodeImpl> myComparator;
    @NotNull
    private SortOrder mySortOrder;

    public InstancesTree(@NotNull Project project, final @NotNull SelectionModel selectionModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "<init>"));
        }
        this.mySortOrder = SortOrder.UNSORTED;
        this.myDebuggerTree = new DebuggerTree(project){

            protected void build(DebuggerContextImpl context) {
                DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
                Instance instance = ((InstanceFieldDescriptorImpl)root.getDescriptor()).getInstance();
                InstancesTree.this.addChildren(root, null, instance);
            }
        };
        this.myHeap = selectionModel.getHeap();
        this.myDebugProcess = new DebugProcessEvents(project);
        final SuspendManagerImpl suspendManager = new SuspendManagerImpl(this.myDebugProcess);
        this.myDebugProcess.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                InstancesTree.this.myDummySuspendContext = suspendManager.pushSuspendContext(0, 1);
            }
        });
        TreeBuilder model = new TreeBuilder(this.myDebuggerTree){

            public void buildChildren(TreeBuilderNode node) {
                DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
                NodeDescriptorImpl descriptor = debuggerTreeNode.getDescriptor();
                if (descriptor instanceof DefaultNodeDescriptor) {
                    return;
                }
                if (descriptor instanceof ContainerDescriptorImpl) {
                    InstancesTree.this.addContainerChildren(debuggerTreeNode, 0);
                } else {
                    InstanceFieldDescriptorImpl instanceDescriptor = (InstanceFieldDescriptorImpl)descriptor;
                    InstancesTree.this.addChildren(debuggerTreeNode, instanceDescriptor.getHprofField(), instanceDescriptor.getInstance());
                }
                InstancesTree.this.sortTree(debuggerTreeNode);
                InstancesTree.this.myDebuggerTree.treeDidChange();
            }

            public boolean isExpandable(TreeBuilderNode builderNode) {
                return ((DebuggerTreeNodeImpl)builderNode).getDescriptor().isExpandable();
            }
        };
        model.setRoot((TreeBuilderNode)this.myDebuggerTree.getNodeFactory().getDefaultNode());
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent event) {
                InstancesTree.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                InstancesTree.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent event) {
                InstancesTree.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent event) {
                InstancesTree.this.myDebuggerTree.hideTooltip();
            }
        });
        this.myDebuggerTree.setModel((TreeModel)model);
        this.myDebuggerTree.setRootVisible(false);
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(@NotNull Heap heap) {
                if (heap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/tables/InstancesTree$5", "onHeapChanged"));
                }
                if (heap != InstancesTree.this.myHeap) {
                    InstancesTree.this.myHeap = heap;
                    if (InstancesTree.this.myDebuggerTree.getMutableModel().getRoot() != null) {
                        this.onSelectionChanged();
                    }
                }
            }

            @Override
            public void onClassObjChanged(@Nullable ClassObj classObj) {
                if (classObj != InstancesTree.this.myClassObj) {
                    InstancesTree.this.myClassObj = classObj;
                    this.onSelectionChanged();
                }
            }

            @Override
            public void onInstanceChanged(@Nullable Instance instance) {
            }

            private void onSelectionChanged() {
                DebuggerTreeNodeImpl newRoot;
                Instance singleChild = null;
                if (InstancesTree.this.myClassObj != null) {
                    ContainerDescriptorImpl containerDescriptor = new ContainerDescriptorImpl(InstancesTree.this.myClassObj, InstancesTree.this.myHeap.getId());
                    newRoot = DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)InstancesTree.this.myDebuggerTree, (NodeDescriptor)containerDescriptor);
                    if (containerDescriptor.getInstances().size() == 1) {
                        singleChild = containerDescriptor.getInstances().get(0);
                    }
                } else {
                    newRoot = InstancesTree.this.myDebuggerTree.getNodeFactory().getDefaultNode();
                }
                InstancesTree.this.myDebuggerTree.getMutableModel().setRoot((TreeBuilderNode)newRoot);
                InstancesTree.this.myDebuggerTree.treeChanged();
                InstancesTree.this.myDebuggerTree.scrollRowToVisible(0);
                if (singleChild != null) {
                    InstancesTree.this.myDebuggerTree.setSelectionInterval(0, 0);
                    selectionModel.setInstance(singleChild);
                }
            }
        });
        this.myDebuggerTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DebuggerTreeNodeImpl lastPathNode;
                TreePath path = e.getPath();
                if (path == null || path.getPathCount() < 2 || !e.isAddedPath()) {
                    selectionModel.setInstance(null);
                    return;
                }
                DebuggerTreeNodeImpl instanceNode = (DebuggerTreeNodeImpl)path.getPathComponent(1);
                if (instanceNode.getDescriptor() instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)instanceNode.getDescriptor();
                    selectionModel.setInstance(descriptor.getInstance());
                }
                if ((lastPathNode = (DebuggerTreeNodeImpl)path.getLastPathComponent()).getDescriptor() instanceof ExpansionDescriptorImpl) {
                    ExpansionDescriptorImpl expansionDescriptor = (ExpansionDescriptorImpl)lastPathNode.getDescriptor();
                    DebuggerTreeNodeImpl parentNode = lastPathNode.getParent();
                    InstancesTree.this.myDebuggerTree.getMutableModel().removeNodeFromParent((TreeBuilderNode)lastPathNode);
                    if (parentNode.getDescriptor() instanceof ContainerDescriptorImpl) {
                        InstancesTree.this.addContainerChildren(parentNode, expansionDescriptor.getStartIndex());
                    } else if (parentNode.getDescriptor() instanceof InstanceFieldDescriptorImpl) {
                        InstanceFieldDescriptorImpl instanceFieldDescriptor = (InstanceFieldDescriptorImpl)parentNode.getDescriptor();
                        InstancesTree.this.addChildren(parentNode, instanceFieldDescriptor.getHprofField(), instanceFieldDescriptor.getInstance(), expansionDescriptor.getStartIndex());
                    }
                    InstancesTree.this.sortTree(parentNode);
                    InstancesTree.this.myDebuggerTree.getMutableModel().nodeStructureChanged((TreeNode)parentNode);
                    if (InstancesTree.this.myComparator != null) {
                        InstancesTree.this.myDebuggerTree.scrollPathToVisible(new TreePath(((DebuggerTreeNodeImpl)parentNode.getLastChild()).getPath()));
                    }
                }
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myDebuggerTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Instance").setPreferredWidth(600).setHeaderAlignment(2).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/editors/hprof/tables/InstancesTree$13", "compare"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/editors/hprof/tables/InstancesTree$13", "compare"));
                }
                return InstancesTree.this.getDefaultOrdering(a, b);
            }
        }).setRenderer((ColoredTreeCellRenderer)((DebuggerTreeRenderer)this.myDebuggerTree.getCellRenderer()))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Depth").setPreferredWidth(60).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                int depthA = 0;
                int depthB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    depthA = instanceA.getDistanceToGcRoot();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    depthB = instanceB.getDistanceToGcRoot();
                }
                if (depthA != depthB) {
                    return depthA - depthB;
                }
                return InstancesTree.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstancesTree$11", "customizeCellRenderer"));
                }
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getDistanceToGcRoot()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/editors/hprof/tables/InstancesTree$10", "compare"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/editors/hprof/tables/InstancesTree$10", "compare"));
                }
                int sizeA = 0;
                int sizeB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    sizeA = instanceA.getSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    sizeB = instanceB.getSize();
                }
                if (sizeA != sizeB) {
                    return sizeA - sizeB;
                }
                return InstancesTree.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstancesTree$9", "customizeCellRenderer"));
                }
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null) {
                        this.append(String.valueOf(instance.getSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Dominating Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/editors/hprof/tables/InstancesTree$8", "compare"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/editors/hprof/tables/InstancesTree$8", "compare"));
                }
                long sizeA = 0L;
                long sizeB = 0L;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null && instanceA.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeA = instanceA.getTotalRetainedSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null && instanceB.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeB = instanceB.getTotalRetainedSize();
                }
                if (sizeA != sizeB) {
                    return (int)(sizeA - sizeB);
                }
                return InstancesTree.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstancesTree$7", "customizeCellRenderer"));
                }
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getTotalRetainedSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        }));
        builder.setTreeSorter(new ColumnTreeBuilder.TreeSorter<DebuggerTreeNodeImpl>(){

            @Override
            public void sort(@NotNull Comparator<DebuggerTreeNodeImpl> comparator, @NotNull SortOrder sortOrder) {
                if (comparator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/android/tools/idea/editors/hprof/tables/InstancesTree$14", "sort"));
                }
                if (sortOrder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortOrder", "com/android/tools/idea/editors/hprof/tables/InstancesTree$14", "sort"));
                }
                if (InstancesTree.this.myComparator != comparator && InstancesTree.this.mySortOrder != sortOrder) {
                    InstancesTree.this.myComparator = comparator;
                    InstancesTree.this.mySortOrder = sortOrder;
                    TreeBuilder mutableModel = InstancesTree.this.myDebuggerTree.getMutableModel();
                    DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)mutableModel.getRoot();
                    InstancesTree.this.sortTree(root);
                    selectionModel.setSelectionLocked(true);
                    TreePath selectionPath = InstancesTree.this.myDebuggerTree.getSelectionPath();
                    mutableModel.nodeStructureChanged((TreeNode)root);
                    InstancesTree.this.myDebuggerTree.setSelectionPath(selectionPath);
                    InstancesTree.this.myDebuggerTree.scrollPathToVisible(selectionPath);
                    selectionModel.setSelectionLocked(false);
                }
            }
        });
        this.myColumnTree = builder.build();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnTree;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "getComponent"));
        }
        return jComponent;
    }

    private void sortTree(@NotNull DebuggerTreeNodeImpl node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "sortTree"));
        }
        if (this.myComparator == null) {
            return;
        }
        Enumeration e = node.rawChildren();
        if (e.hasMoreElements()) {
            ArrayList<DebuggerTreeNodeImpl> builtChildren = Collections.list(e);
            DebuggerTreeNodeImpl expansionNode = builtChildren.get(builtChildren.size() - 1);
            if (expansionNode.getDescriptor() instanceof ExpansionDescriptorImpl) {
                builtChildren.remove(builtChildren.size() - 1);
            } else {
                expansionNode = null;
            }
            Collections.sort(builtChildren, this.myComparator);
            node.removeAllChildren();
            for (DebuggerTreeNodeImpl childNode : builtChildren) {
                node.add((MutableTreeNode)childNode);
                this.sortTree(childNode);
            }
            if (expansionNode != null) {
                node.add((MutableTreeNode)expansionNode);
            }
        }
    }

    private int getDefaultOrdering(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
        Instance parentInstance;
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "getDefaultOrdering"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "getDefaultOrdering"));
        }
        NodeDescriptorImpl parentDescriptor = a.getParent().getDescriptor();
        if (parentDescriptor instanceof InstanceFieldDescriptorImpl ? (parentInstance = ((InstanceFieldDescriptorImpl)parentDescriptor).getInstance()) instanceof ArrayInstance : parentDescriptor instanceof ContainerDescriptorImpl) {
            return this.getMemoryOrderingSortResult(a, b);
        }
        return a.getDescriptor().getLabel().compareTo(b.getDescriptor().getLabel());
    }

    private int getMemoryOrderingSortResult(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "getMemoryOrderingSortResult"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "getMemoryOrderingSortResult"));
        }
        return ((HprofFieldDescriptorImpl)a.getDescriptor()).getMemoryOrdering() - ((HprofFieldDescriptorImpl)b.getDescriptor()).getMemoryOrdering() ^ (this.mySortOrder == SortOrder.ASCENDING ? 1 : -1);
    }

    private void addContainerChildren(@NotNull DebuggerTreeNodeImpl node, int startIndex) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "addContainerChildren"));
        }
        ContainerDescriptorImpl containerDescriptor = (ContainerDescriptorImpl)node.getDescriptor();
        List<Instance> instances = containerDescriptor.getInstances();
        ArrayList<HprofFieldDescriptorImpl> descriptors = new ArrayList<HprofFieldDescriptorImpl>(100);
        int currentIndex = startIndex;
        int limit = currentIndex + 100;
        for (int loopCounter = currentIndex; loopCounter < instances.size() && currentIndex < limit; ++loopCounter) {
            Instance instance = instances.get(loopCounter);
            if (this.myHeap.getInstance(instance.getId()) == null) continue;
            descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(Type.OBJECT, String.format("0x%x (%d)", instance.getUniqueId(), currentIndex)), instance, currentIndex));
            ++currentIndex;
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentIndex == limit) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("instances", limit, instances.size())));
        }
    }

    private void addChildren(@NotNull DebuggerTreeNodeImpl node, @Nullable Field field, @Nullable Instance instance) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "addChildren"));
        }
        this.addChildren(node, field, instance, 0);
    }

    private void addChildren(@NotNull DebuggerTreeNodeImpl node, @Nullable Field field, @Nullable Instance instance, int arrayStartIndex) {
        ArrayList<HprofFieldDescriptorImpl> descriptors;
        int currentArrayIndex;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/tables/InstancesTree", "addChildren"));
        }
        if (instance == null) {
            return;
        }
        int limit = currentArrayIndex + 100;
        int arrayLength = 0;
        if (instance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)instance;
            descriptors = new ArrayList<HprofFieldDescriptorImpl>(classInstance.getValues().size());
            int i = 0;
            for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                if (entry.getField().getType() == Type.OBJECT) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), (Instance)entry.getValue(), i));
                } else {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), entry.getValue(), i));
                }
                ++i;
            }
        } else if (instance instanceof ArrayInstance) {
            assert (field != null);
            ArrayInstance arrayInstance = (ArrayInstance)instance;
            Object[] values = arrayInstance.getValues();
            descriptors = new ArrayList(values.length);
            arrayLength = values.length;
            if (arrayInstance.getArrayType() == Type.OBJECT) {
                for (currentArrayIndex = arrayStartIndex; currentArrayIndex < arrayLength && currentArrayIndex < limit; ++currentArrayIndex) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), (Instance)values[currentArrayIndex], currentArrayIndex));
                }
            } else {
                while (currentArrayIndex < arrayLength && currentArrayIndex < limit) {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), values[currentArrayIndex], currentArrayIndex));
                    ++currentArrayIndex;
                }
            }
        } else {
            throw new RuntimeException("Unimplemented Instance type in addChildren.");
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentArrayIndex == limit) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("array elements", limit, arrayLength)));
        }
    }
}

