/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ThemeResolver {
    private static final Logger LOG = Logger.getInstance(ThemeResolver.class);
    private final Set<String> myThemeNames;
    private final List<ThemeEditorStyle> myAllThemes;
    private final List<ThemeEditorStyle> myFrameworkThemes;
    private final List<ThemeEditorStyle> myProjectThemes;
    private final List<ThemeEditorStyle> myProjectLocalThemes;
    private final StyleResolver myStyleResolver;

    public ThemeResolver(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeResolver", "<init>"));
        }
        this(configuration, new StyleResolver(configuration));
    }

    public ThemeResolver(@NotNull Configuration configuration, @NotNull StyleResolver styleResolver) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeResolver", "<init>"));
        }
        if (styleResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResolver", "com/android/tools/idea/editors/theme/ThemeResolver", "<init>"));
        }
        this.myThemeNames = Sets.newHashSet();
        this.myStyleResolver = styleResolver;
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            this.myProjectLocalThemes = Collections.emptyList();
            this.myFrameworkThemes = this.myProjectLocalThemes;
            this.myProjectThemes = this.myProjectLocalThemes;
            this.myAllThemes = this.myProjectLocalThemes;
            LOG.error("Unable to get IAndroidTarget.");
            return;
        }
        final LinkedList<StyleResourceValue> localThemes = new LinkedList<StyleResourceValue>(ThemeResolver.getProjectThemesNoLibraries(configuration));
        final LinkedList<StyleResourceValue> resolvedThemes = new LinkedList<StyleResourceValue>(ThemeResolver.getProjectThemes(configuration));
        final LinkedList<StyleResourceValue> frameworkThemes = new LinkedList<StyleResourceValue>(ThemeResolver.getFrameworkThemes(configuration));
        this.myProjectLocalThemes = Lists.newArrayListWithCapacity((int)resolvedThemes.size());
        this.myProjectThemes = Lists.newArrayListWithExpectedSize((int)(resolvedThemes.size() * 2));
        this.myFrameworkThemes = Lists.newArrayListWithCapacity((int)frameworkThemes.size());
        this.myAllThemes = Lists.newArrayListWithExpectedSize((int)(resolvedThemes.size() * 2 + frameworkThemes.size()));
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, configuration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        if (resolver == null) {
            LOG.error("Unable to get ResourceResolver.");
            return;
        }
        AppResourceRepository resources = AppResourceRepository.getAppResources(configuration.getModule(), true);
        if (resources == null) {
            LOG.error("Unable to get AppResourceRepository.");
            return;
        }
        ForwardingQueue<StyleResourceValue> pendingThemes = new ForwardingQueue<StyleResourceValue>(){

            protected Queue<StyleResourceValue> delegate() {
                if (!localThemes.isEmpty()) {
                    return localThemes;
                }
                if (!resolvedThemes.isEmpty()) {
                    return resolvedThemes;
                }
                return frameworkThemes;
            }
        };
        while (!pendingThemes.isEmpty()) {
            boolean isLocalTheme = !localThemes.isEmpty();
            boolean isProjectDependency = isLocalTheme || !resolvedThemes.isEmpty();
            StyleResourceValue style = (StyleResourceValue)pendingThemes.remove();
            String styleQualifiedName = StyleResolver.getQualifiedStyleName(style);
            if (this.myThemeNames.contains(styleQualifiedName)) continue;
            this.myThemeNames.add(styleQualifiedName);
            ThemeEditorStyle resolvedStyle = this.myStyleResolver.getStyle(styleQualifiedName);
            this.myAllThemes.add(resolvedStyle);
            if (isProjectDependency) {
                this.myProjectThemes.add(resolvedStyle);
                StyleResourceValue parent = resolver.getParent(style);
                if (parent != null) {
                    resolvedThemes.add(parent);
                }
            }
            if (isLocalTheme) {
                this.myProjectLocalThemes.add(resolvedStyle);
                continue;
            }
            this.myFrameworkThemes.add(resolvedStyle);
        }
    }

    @NotNull
    private static List<StyleResourceValue> getFrameworkThemes(@NotNull Configuration myConfiguration) {
        if (myConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myConfiguration", "com/android/tools/idea/editors/theme/ThemeResolver", "getFrameworkThemes"));
        }
        ResourceRepository repository = myConfiguration.getFrameworkResources();
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getFrameworkThemes"));
            }
            return list;
        }
        Map resources = repository.getConfiguredResources(myConfiguration.getFullConfig());
        List<StyleResourceValue> list = ThemeResolver.getThemes(myConfiguration, resources, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getFrameworkThemes"));
        }
        return list;
    }

    @NotNull
    private static List<StyleResourceValue> getProjectThemes(@NotNull Configuration myConfiguration) {
        if (myConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myConfiguration", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemes"));
        }
        AppResourceRepository repository = AppResourceRepository.getAppResources(myConfiguration.getModule(), true);
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemes"));
            }
            return list;
        }
        Map resources = repository.getConfiguredResources(myConfiguration.getFullConfig());
        List<StyleResourceValue> list = ThemeResolver.getThemes(myConfiguration, resources, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemes"));
        }
        return list;
    }

    @NotNull
    private static List<StyleResourceValue> getProjectThemesNoLibraries(@NotNull Configuration myConfiguration) {
        if (myConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myConfiguration", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemesNoLibraries"));
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(myConfiguration.getModule(), true);
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemesNoLibraries"));
            }
            return list;
        }
        Map resources = repository.getConfiguredResources(myConfiguration.getFullConfig());
        List<StyleResourceValue> list = ThemeResolver.getThemes(myConfiguration, resources, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemesNoLibraries"));
        }
        return list;
    }

    @NotNull
    private static List<StyleResourceValue> getThemes(@NotNull Configuration configuration, @NotNull Map<ResourceType, Map<String, ResourceValue>> resources, boolean isFramework) {
        ResourceResolver resolver;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        Map<String, ResourceValue> styles = resources.get(ResourceType.STYLE);
        Collection<ResourceValue> values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        if (!isFramework && (resolver = configuration.getResourceResolver()) != null) {
            HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
            for (ResourceValue value : values) {
                StyleResourceValue styleValue;
                if (!(value instanceof StyleResourceValue) || !resolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value), (Map)cache)) continue;
                themes.add(styleValue);
            }
            ArrayList<StyleResourceValue> arrayList = themes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
            }
            return arrayList;
        }
        for (ResourceValue value : values) {
            String name = value.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        return arrayList;
    }

    public boolean isTheme(@NotNull ThemeEditorStyle style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ThemeResolver", "isTheme"));
        }
        return this.myThemeNames.contains(style.getName());
    }

    @Nullable
    public ThemeEditorStyle getTheme(@NotNull String themeName) {
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/editors/theme/ThemeResolver", "getTheme"));
        }
        if (this.myThemeNames.contains(themeName)) {
            return this.myStyleResolver.getStyle(themeName);
        }
        return null;
    }

    @NotNull
    public Collection<ThemeEditorStyle> getLocalThemes() {
        List<ThemeEditorStyle> list = Collections.unmodifiableList(this.myProjectLocalThemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getLocalThemes"));
        }
        return list;
    }

    @NotNull
    public Collection<ThemeEditorStyle> getProjectThemes() {
        List<ThemeEditorStyle> list = Collections.unmodifiableList(this.myProjectThemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getProjectThemes"));
        }
        return list;
    }

    @NotNull
    public Collection<ThemeEditorStyle> getFrameworkThemes() {
        List<ThemeEditorStyle> list = Collections.unmodifiableList(this.myFrameworkThemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getFrameworkThemes"));
        }
        return list;
    }

    @NotNull
    Collection<ThemeEditorStyle> getThemes() {
        Collection<ThemeEditorStyle> collection = Collections.unmodifiableCollection(this.myAllThemes);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        return collection;
    }
}

