/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeEditorValue;
import com.android.tools.idea.editors.theme.attributes.editors.ColorComponent;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorEditor
extends TypedCellEditor<EditedStyleItem, AttributeEditorValue> {
    private static final Logger LOG = Logger.getInstance(ColorEditor.class);
    private final ThemeEditorContext myContext;
    private final ColorComponent myComponent;
    private AttributeEditorValue myEditorValue;
    private final AndroidThemePreviewPanel myPreviewPanel;
    private EditedStyleItem myItem;

    public ColorEditor(@NotNull ThemeEditorContext context, AndroidThemePreviewPanel previewPanel) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorEditor", "<init>"));
        }
        this.myEditorValue = null;
        this.myContext = context;
        this.myComponent = new ColorComponent();
        this.myComponent.addActionListener(new ColorEditorActionListener());
        this.myPreviewPanel = previewPanel;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myItem = value;
        ResourceResolver resourceResolver = this.myContext.getResourceResolver();
        assert (resourceResolver != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, (ResourceValue)this.myItem.getItemResourceValue());
        this.myComponent.configure(this.myItem, colors);
        this.myEditorValue = null;
        return this.myComponent;
    }

    @Override
    public AttributeEditorValue getEditorValue() {
        return this.myEditorValue;
    }

    private class ColorEditorActionListener
    implements ActionListener {
        private ColorEditorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String itemValue = ColorEditor.this.myItem.getValue();
            String colorName = !"@null".equals(itemValue) && itemValue.startsWith("@") ? itemValue.substring(itemValue.indexOf(47) + 1) : ColorEditor.this.myItem.getName();
            ResourceResolver resourceResolver = ColorEditor.this.myContext.getResourceResolver();
            assert (resourceResolver != null);
            String resolvedColor = ResourceHelper.colorToString(ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)ColorEditor.this.myItem.getItemResourceValue()));
            ChooseResourceDialog dialog = new ChooseResourceDialog(ColorEditor.this.myContext.getCurrentThemeModule(), ChooseResourceDialog.COLOR_TYPES, resolvedColor, null, ChooseResourceDialog.ResourceNameVisibility.FORCE, colorName);
            final String oldValue = ColorEditor.this.myItem.getItemResourceValue().getValue();
            final ScheduledExecutorService changeScheduler = Executors.newSingleThreadScheduledExecutor();
            final AtomicReference nextTimer = new AtomicReference();
            dialog.setResourcePickerListener(new ChooseResourceDialog.ResourcePickerListener(){

                @Override
                public void resourceChanged(final @Nullable String resource) {
                    ScheduledFuture<?> previousTimer = nextTimer.getAndSet(changeScheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        ColorEditor.this.myItem.getItemResourceValue().setValue(resource == null ? oldValue : resource);
                                        ColorEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
                                    }
                                });
                            }
                            catch (InterruptedException e1) {
                            }
                            catch (InvocationTargetException e1) {
                                LOG.error("Exception updating resource", (Throwable)e1);
                            }
                        }
                    }, 150L, TimeUnit.MILLISECONDS));
                    if (previousTimer != null) {
                        previousTimer.cancel(true);
                    }
                }
            });
            dialog.show();
            changeScheduler.shutdown();
            ColorEditor.this.myItem.getItemResourceValue().setValue(oldValue);
            ColorEditor.this.myEditorValue = null;
            if (dialog.isOK()) {
                String value = dialog.getResourceName();
                if (value != null) {
                    ColorEditor.this.myEditorValue = new AttributeEditorValue(dialog.getResourceName(), dialog.overwriteResource());
                }
            } else {
                ColorEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
            }
            if (ColorEditor.this.myEditorValue == null) {
                ColorEditor.this.cancelCellEditing();
            } else {
                ColorEditor.this.stopCellEditing();
            }
        }
    }
}

