/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.ResourceComponent;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.swing.util.GraphicsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableComponent
extends ResourceComponent {
    private final List<BufferedImage> myImages = new ArrayList<BufferedImage>();
    private ImageIcon myIcon = new ImageIcon();

    @Override
    int getIconCount() {
        return this.myImages.size();
    }

    @Override
    Icon getIconAt(int i) {
        this.myIcon.setImage(this.myImages.get(i));
        return this.myIcon;
    }

    @Override
    void setIconHeight(int height) {
        this.myIcon.setHeight(height);
    }

    public void configure(@NotNull EditedStyleItem item, @Nullable RenderTask renderTask) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/attributes/editors/DrawableComponent", "configure"));
        }
        this.configure(ThemeEditorUtils.getDisplayHtml(item), "drawable", item.getValue());
        this.myImages.clear();
        if (renderTask != null) {
            this.myImages.addAll(renderTask.renderDrawableAllStates((ResourceValue)item.getItemResourceValue()));
        }
    }

    static class ImageIcon
    extends javax.swing.ImageIcon {
        private int myHeight;

        ImageIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Image image = this.getImage();
            GraphicsUtil.paintCheckeredBackground(g, new Rectangle(x, y, this.getIconWidth(), this.getIconHeight()));
            g.drawImage(image, x, y, this.getIconWidth(), this.getIconHeight(), c);
        }

        public void setHeight(int height) {
            this.myHeight = height;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }

        @Override
        public int getIconWidth() {
            return this.myHeight * super.getIconWidth() / super.getIconHeight();
        }
    }
}

