/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableComponent;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;

public class DrawableRenderer
implements TableCellRenderer,
ThemeEditorContext.ChangeListener {
    private final DrawableComponent myComponent;
    private RenderTask myRenderTask;

    public DrawableRenderer(ThemeEditorContext context) {
        this.myRenderTask = DrawableRenderer.configureRenderTask(context);
        context.addChangeListener(this);
        this.myComponent = new DrawableComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myComponent.configure((EditedStyleItem)value, this.myRenderTask);
        return this.myComponent;
    }

    public static RenderTask configureRenderTask(ThemeEditorContext context) {
        RenderTask result = null;
        AndroidFacet facet = AndroidFacet.getInstance(context.getCurrentThemeModule());
        if (facet != null) {
            RenderService service = RenderService.get(facet);
            result = service.createTask(null, context.getConfiguration(), new RenderLogger("ThemeEditorLogger", context.getCurrentThemeModule()), null);
        }
        return result;
    }

    @Override
    public void onNewConfiguration(ThemeEditorContext context) {
        this.myRenderTask = DrawableRenderer.configureRenderTask(context);
    }
}

