/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    private final boolean myIsFrameworkStyle;
    @NotNull
    private final StyleResolver myThemeResolver;
    @NotNull
    private final String myStyleName;
    @NotNull
    private final Configuration myConfiguration;
    private final Project myProject;

    public ThemeEditorStyle(@NotNull StyleResolver resolver, @NotNull Configuration configuration, @NotNull String styleName, boolean isFrameworkStyle) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        this.myIsFrameworkStyle = isFrameworkStyle;
        this.myThemeResolver = resolver;
        this.myConfiguration = configuration;
        this.myStyleName = styleName;
        this.myProject = configuration.getModule().getProject();
    }

    public boolean isProjectStyle() {
        if (this.myIsFrameworkStyle) {
            return false;
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(this.myConfiguration.getModule(), true);
        assert (repository != null) : this.myConfiguration.getModule().getName();
        return repository.hasResourceItem(ResourceType.STYLE, this.myStyleName);
    }

    @NotNull
    private StyleResourceValue getStyleResourceValue() {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue result = resolver.getStyle(this.myStyleName, this.myIsFrameworkStyle);
        assert (result != null);
        StyleResourceValue styleResourceValue = result;
        if (styleResourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceValue"));
        }
        return styleResourceValue;
    }

    @NotNull
    private List<ResourceItem> getResources() {
        assert (!this.myIsFrameworkStyle);
        AppResourceRepository repository = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true);
        assert (repository != null);
        List<ResourceItem> resources = repository.getResourceItem(ResourceType.STYLE, this.myStyleName);
        List<ResourceItem> list = resources != null ? resources : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getResources"));
        }
        return list;
    }

    public boolean isReadOnly() {
        return !this.isProjectStyle();
    }

    @NotNull
    public String getName() {
        String string = StyleResolver.getQualifiedStyleName(this.getStyleResourceValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getName"));
        }
        return string;
    }

    @NotNull
    public String getSimpleName() {
        String string = this.getStyleResourceValue().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getSimpleName"));
        }
        return string;
    }

    @NotNull
    public Collection<ItemResourceValue> getValues() {
        Collection collection = this.getStyleResourceValue().getValues();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValues"));
        }
        return collection;
    }

    public boolean hasItem(@Nullable EditedStyleItem item) {
        return item != null && this.getStyleResourceValue().getItem(item.getName(), item.isFrameworkAttr()) != null;
    }

    @Nullable
    public ThemeEditorStyle getParent() {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue parent = resolver.getParent(this.getStyleResourceValue());
        if (parent == null) {
            return null;
        }
        return this.myThemeResolver.getStyle(StyleResolver.getQualifiedStyleName(parent));
    }

    @Nullable
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTag", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    @Nullable
    public String getValue(@NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValue"));
        }
        throw new UnsupportedOperationException();
    }

    public void setValue(final @NotNull String attribute, final @NotNull String value) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final int minAcceptableApi = Math.max(ThemeEditorUtils.getOriginalApiLevel(attribute, this.myProject), ThemeEditorUtils.getOriginalApiLevel(value, this.myProject));
        final ApiInformation apiInformation = new ApiInformation(minAcceptableApi);
        HashSet toBeEdited = new HashSet();
        for (XmlTag sourceXml : apiInformation.sources) {
            toBeEdited.add(sourceXml.getContainingFile());
        }
        new WriteCommandAction.Simple(this.myProject, "Setting value of " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()])){

            protected void run() {
                for (XmlTag sourceXml : apiInformation.sources) {
                    XmlTag tag = ThemeEditorStyle.this.getValueTag(sourceXml, attribute);
                    if (tag != null) {
                        tag.getValue().setEscapedText(value);
                        apiInformation.toBeCopied = null;
                        continue;
                    }
                    XmlTag child = sourceXml.createChildTag("item", sourceXml.getNamespace(), value, false);
                    child.setAttribute("name", attribute);
                    sourceXml.addSubTag(child, false);
                }
                if (apiInformation.toBeCopied != null) {
                    ThemeEditorUtils.copyTheme(minAcceptableApi, apiInformation.toBeCopied);
                    AndroidFacet facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myConfiguration.getModule());
                    if (facet != null) {
                        facet.refreshResources();
                    }
                    List newResources = ThemeEditorStyle.this.getResources();
                    VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
                    for (ResourceItem resourceItem : newResources) {
                        if (!resourceItem.getQualifiers().contains(qualifier.getFolderSegment())) continue;
                        XmlTag sourceXml = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, resourceItem);
                        assert (sourceXml != null);
                        XmlTag child = sourceXml.createChildTag("item", sourceXml.getNamespace(), value, false);
                        child.setAttribute("name", attribute);
                        sourceXml.addSubTag(child, false);
                        break;
                    }
                }
            }
        }.execute();
    }

    public void setParent(final @NotNull String newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final int minAcceptableApi = ThemeEditorUtils.getOriginalApiLevel(newParent, this.myProject);
        final ApiInformation apiInformation = new ApiInformation(minAcceptableApi);
        HashSet toBeEdited = new HashSet();
        for (XmlTag sourceXml : apiInformation.sources) {
            toBeEdited.add(sourceXml.getContainingFile());
        }
        new WriteCommandAction.Simple(this.myProject, "Updating parent to " + newParent, toBeEdited.toArray(new PsiFile[toBeEdited.size()])){

            protected void run() {
                for (XmlTag sourceXml : apiInformation.sources) {
                    sourceXml.setAttribute("parent", newParent);
                }
                if (apiInformation.toBeCopied != null) {
                    ThemeEditorUtils.copyTheme(minAcceptableApi, apiInformation.toBeCopied);
                    AndroidFacet facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myConfiguration.getModule());
                    if (facet != null) {
                        facet.refreshResources();
                    }
                    List newResources = ThemeEditorStyle.this.getResources();
                    VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
                    for (ResourceItem resourceItem : newResources) {
                        if (!resourceItem.getQualifiers().contains(qualifier.getFolderSegment())) continue;
                        XmlTag sourceXml = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, resourceItem);
                        assert (sourceXml != null);
                        sourceXml.setAttribute("parent", newParent);
                        break;
                    }
                }
            }
        }.execute();
    }

    @NotNull
    public StyleResolver getResolver() {
        StyleResolver styleResolver = this.myThemeResolver;
        if (styleResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getResolver"));
        }
        return styleResolver;
    }

    public String toString() {
        if (!this.isReadOnly()) {
            return "[" + this.getSimpleName() + "]";
        }
        return this.getSimpleName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ThemeEditorStyle)) {
            return false;
        }
        return this.getName().equals(((ThemeEditorStyle)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getConfiguration"));
        }
        return configuration;
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "removeAttribute"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        HashSet toBeEdited = new HashSet();
        HashSet toBeRemoved = new HashSet();
        for (ResourceItem resourceItem : this.getResources()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(this.myProject, "Removing " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()]), (Collection)toBeRemoved){
            final /* synthetic */ Collection val$toBeRemoved;
            {
                this.val$toBeRemoved = collection;
                super(x0, x1, x2);
            }

            protected void run() {
                for (XmlTag tag : this.val$toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        List<ResourceItem> resources = this.getResources();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resources.get(0));
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    public boolean isPublic() {
        if (!this.myIsFrameworkStyle) {
            return true;
        }
        IAndroidTarget target = this.myConfiguration.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myConfiguration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getSimpleName());
    }

    private class ApiInformation {
        private final Collection<XmlTag> sources = new HashSet();
        private XmlTag toBeCopied = null;

        private ApiInformation(int minAcceptableApi) {
            int minApiLevel = ThemeEditorUtils.getMinApiLevel(ThemeEditorStyle.this.myConfiguration.getModule());
            int closestNonAllowedApi = 0;
            boolean createNewTheme = true;
            if (minAcceptableApi < minApiLevel) {
                createNewTheme = false;
            }
            for (ResourceItem resourceItem : ThemeEditorStyle.this.getResources()) {
                VersionQualifier versionQualifier;
                FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString((String)resourceItem.getQualifiers());
                int version = minApiLevel;
                if (folderConfiguration != null && (versionQualifier = folderConfiguration.getVersionQualifier()) != null && versionQualifier.isValid()) {
                    version = versionQualifier.getVersion();
                }
                XmlTag sourceXml = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, resourceItem);
                assert (sourceXml != null);
                if (version < minAcceptableApi) {
                    if (version <= closestNonAllowedApi) continue;
                    closestNonAllowedApi = version;
                    this.toBeCopied = sourceXml;
                    continue;
                }
                if (version == minAcceptableApi) {
                    createNewTheme = false;
                }
                this.sources.add(sourceXml);
            }
            if (!createNewTheme) {
                this.toBeCopied = null;
            }
        }
    }
}

