/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, @NotNull JavaParameters javaParameters) {
        if (javaParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParameters", "com/android/tools/idea/gradle/AndroidJunitPatcher", "patchJavaParameters"));
        }
        if (module == null) {
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null) {
            return;
        }
        IdeaAndroidProject ideaAndroidProject = androidFacet.getIdeaAndroidProject();
        if (ideaAndroidProject == null) {
            return;
        }
        BaseArtifact testArtifact = ideaAndroidProject.findSelectedTestArtifactInSelectedVariant();
        if (testArtifact == null) {
            return;
        }
        if (!"_unit_test_".equals(testArtifact.getName()) || !(testArtifact instanceof JavaArtifact)) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return;
        }
        AndroidJunitPatcher.handlePlatformJar(classPath, platform, (JavaArtifact)testArtifact);
        AndroidJunitPatcher.handleJavaResources(ideaAndroidProject, classPath);
    }

    private static void handlePlatformJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull JavaArtifact artifact) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handlePlatformJar"));
        }
        String androidJarPath = platform.getTarget().getPath(1);
        for (String entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove(entry);
        }
        List mockableJars = ContainerUtil.newSmartList();
        for (String path : classPath.getPathList()) {
            if (!new File(FileUtil.toSystemDependentName((String)path)).getName().startsWith("mockable-")) continue;
            mockableJars.add(path);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = AndroidJunitPatcher.getMockableJarFromModel(artifact);
        if (mockableJar == null) {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
            throw new IllegalStateException("Could not find matching mockable platform jar.");
        }
        classPath.addTail(mockableJar.getPath());
    }

    @Nullable
    private static File getMockableJarFromModel(@NotNull JavaArtifact model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/AndroidJunitPatcher", "getMockableJarFromModel"));
        }
        try {
            return model.getMockablePlatformJar();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    private static void handleJavaResources(@NotNull IdeaAndroidProject ideaAndroidProject, @NotNull PathsList classPath) {
        if (ideaAndroidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaAndroidProject", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handleJavaResources"));
        }
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/gradle/AndroidJunitPatcher", "handleJavaResources"));
        }
        BaseArtifact testArtifact = ideaAndroidProject.findSelectedTestArtifactInSelectedVariant();
        if (testArtifact == null) {
            return;
        }
        try {
            classPath.add(ideaAndroidProject.getSelectedVariant().getMainArtifact().getJavaResourcesFolder());
            classPath.add(testArtifact.getJavaResourcesFolder());
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
    }
}

