/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.base.Strings;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacetModuleCustomizer
implements ModuleCustomizer<IdeaAndroidProject> {
    private static final String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customizeModule(@NotNull Project project, @NotNull ModifiableRootModel ideaModuleModel, @Nullable IdeaAndroidProject androidProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "customizeModule"));
        }
        if (ideaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModuleModel", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "customizeModule"));
        }
        Module module = ideaModuleModel.getModule();
        if (androidProject == null) {
            Facets.removeAllFacetsOfType(module, AndroidFacet.ID);
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null) {
                AndroidFacetModuleCustomizer.configureFacet(facet, androidProject);
            } else {
                FacetManager facetManager = FacetManager.getInstance((Module)module);
                ModifiableFacetModel model = facetManager.createModifiableModel();
                try {
                    facet = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
                    model.addFacet((Facet)facet);
                    AndroidFacetModuleCustomizer.configureFacet(facet, androidProject);
                }
                finally {
                    model.commit();
                }
            }
        }
    }

    private static void configureFacet(@NotNull AndroidFacet facet, @NotNull IdeaAndroidProject ideaAndroidProject) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "configureFacet"));
        }
        if (ideaAndroidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaAndroidProject", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "configureFacet"));
        }
        JpsAndroidModuleProperties facetState = facet.getProperties();
        facetState.ALLOW_USER_CONFIGURATION = false;
        AndroidProject delegate = ideaAndroidProject.getDelegate();
        facetState.LIBRARY_PROJECT = delegate.isLibrary();
        SourceProvider sourceProvider = delegate.getDefaultConfig().getSourceProvider();
        AndroidFacetModuleCustomizer.syncSelectedVariantAndTestArtifact(facetState, ideaAndroidProject);
        File moduleDirPath = ideaAndroidProject.getRootDirPath();
        File manifestFile = sourceProvider.getManifestFile();
        facetState.MANIFEST_FILE_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, manifestFile);
        Collection resDirs = sourceProvider.getResDirectories();
        facetState.RES_FOLDER_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, resDirs);
        Collection assetsDirs = sourceProvider.getAssetsDirectories();
        facetState.ASSETS_FOLDER_RELATIVE_PATH = AndroidFacetModuleCustomizer.relativePath(moduleDirPath, assetsDirs);
        facet.setIdeaAndroidProject(ideaAndroidProject);
        facet.syncSelectedVariantAndTestArtifact();
    }

    private static void syncSelectedVariantAndTestArtifact(@NotNull JpsAndroidModuleProperties facetState, @NotNull IdeaAndroidProject ideaAndroidProject) {
        String testArtifactStoredInFacet;
        if (facetState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetState", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "syncSelectedVariantAndTestArtifact"));
        }
        if (ideaAndroidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaAndroidProject", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "syncSelectedVariantAndTestArtifact"));
        }
        String variantStoredInFacet = facetState.SELECTED_BUILD_VARIANT;
        if (!Strings.isNullOrEmpty((String)variantStoredInFacet) && ideaAndroidProject.getVariantNames().contains(variantStoredInFacet)) {
            ideaAndroidProject.setSelectedVariantName(variantStoredInFacet);
        }
        if (!Strings.isNullOrEmpty((String)(testArtifactStoredInFacet = facetState.SELECTED_TEST_ARTIFACT))) {
            ideaAndroidProject.setSelectedTestArtifactName(testArtifactStoredInFacet);
        }
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<File> dirs) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
        }
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
        }
        String string = AndroidFacetModuleCustomizer.relativePath(basePath, (File)ContainerUtil.getFirstItem(dirs));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
        }
        return string;
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable File file) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
        }
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)file);
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            String string = SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/AndroidFacetModuleCustomizer", "relativePath"));
        }
        return "";
    }
}

