/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleBuildFileUpdater;
import com.android.tools.idea.gradle.project.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProjectBuilder;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.Lists;
import com.intellij.ProjectTopics;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public class AndroidGradleProjectComponent
extends AbstractProjectComponent {
    @NonNls
    private static final String SHOW_MIGRATE_TO_GRADLE_POPUP = "show.migrate.to.gradle.popup";
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "getInstance"));
        }
        AndroidGradleProjectComponent androidGradleProjectComponent = (AndroidGradleProjectComponent)((Object)ServiceManager.getService((Project)project, AndroidGradleProjectComponent.class));
        if (androidGradleProjectComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "getInstance"));
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "<init>"));
        }
        super(project);
        ProjectBuilder.getInstance(project).addAfterProjectBuildTask(new ProjectBuilder.AfterProjectBuildTask(){

            @Override
            public void execute(@NotNull GradleInvocationResult result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$1", "execute"));
                }
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(result);
            }

            public boolean execute(CompileContext context) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                return true;
            }
        });
    }

    public void projectOpened() {
        this.checkForSupportedModules();
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            syncState.notifyUser();
        }
        if (this.shouldShowMigrateToGradleNotification() && AndroidStudioSpecificInitializer.isAndroidStudio() && Projects.isIdeaAndroidProject(this.myProject)) {
            this.showMigrateToGradleWarning();
            return;
        }
        boolean isGradleProject = Projects.isBuildWithGradle(this.myProject);
        if (isGradleProject) {
            this.configureGradleProject();
        }
    }

    private boolean shouldShowMigrateToGradleNotification() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_MIGRATE_TO_GRADLE_POPUP, true);
    }

    private void showMigrateToGradleWarning() {
        String errMsg = "This project does not use the Gradle build system. We recommend that you migrate to using the Gradle build system.";
        OpenMigrationToGradleUrlHyperlink moreInfoHyperlink = new OpenMigrationToGradleUrlHyperlink();
        NotificationHyperlink doNotShowAgainHyperlink = new NotificationHyperlink("do.not.show", "Don't show this message again."){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$2", "execute"));
                }
                PropertiesComponent.getInstance((Project)AndroidGradleProjectComponent.this.myProject).setValue(AndroidGradleProjectComponent.SHOW_MIGRATE_TO_GRADLE_POPUP, Boolean.FALSE.toString());
            }
        };
        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
        notification.showBalloon("Migrate Project to Gradle?", errMsg, NotificationType.WARNING, moreInfoHyperlink, doNotShowAgainHyperlink);
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        AndroidGradleProjectComponent.listenForProjectChanges(this.myProject, this.myDisposable);
        Projects.enforceExternalBuild(this.myProject);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        runConfigurationProducerManager.addIgnoredProducer(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerManager.addIgnoredProducer(TestMethodGradleConfigurationProducer.class);
        runConfigurationProducerManager.addIgnoredProducer(TestClassGradleConfigurationProducer.class);
    }

    private static void listenForProjectChanges(@NotNull Project project, @NotNull Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "listenForProjectChanges"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "listenForProjectChanges"));
        }
        GradleBuildFileUpdater buildFileUpdater = new GradleBuildFileUpdater(project);
        GradleModuleListener moduleListener = new GradleModuleListener();
        moduleListener.addModuleListener((ModuleListener)buildFileUpdater);
        MessageBusConnection connection = project.getMessageBus().connect(disposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)moduleListener);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)buildFileUpdater);
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    public void checkForSupportedModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 0 || !Projects.isBuildWithGradle(this.myProject)) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        for (Module module : modules) {
            ModuleType moduleType = ModuleType.get((Module)module);
            if (!(moduleType instanceof JavaModuleType)) continue;
            String externalSystemId = module.getOptionValue("external.system.id");
            if (GradleUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) continue;
            unsupportedModules.add(module);
        }
        if (unsupportedModules.size() == 0) {
            return;
        }
        String s = StringUtil.join(unsupportedModules, (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return module.getName();
            }
        }, (String)", ");
        AndroidGradleNotification.getInstance(this.myProject).showBalloon("Unsupported Modules Detected", "Compilation is not supported for following modules: " + s + ". Unfortunately you can't have non-Gradle Java modules and Android-Gradle modules in one project.", NotificationType.ERROR);
    }

    private static class GradleModuleListener
    implements ModuleListener {
        @NotNull
        private final List<ModuleListener> additionalListeners = Lists.newArrayList();

        private GradleModuleListener() {
        }

        public void moduleAdded(Project project, Module module) {
            GradleModuleListener.updateBuildVariantView(project);
            for (ModuleListener listener : this.additionalListeners) {
                listener.moduleAdded(project, module);
            }
        }

        public void beforeModuleRemoved(Project project, Module module) {
            for (ModuleListener listener : this.additionalListeners) {
                listener.beforeModuleRemoved(project, module);
            }
        }

        public void modulesRenamed(Project project, List<Module> modules, Function<Module, String> oldNameProvider) {
            GradleModuleListener.updateBuildVariantView(project);
            for (ModuleListener listener : this.additionalListeners) {
                listener.modulesRenamed(project, modules, oldNameProvider);
            }
        }

        public void moduleRemoved(Project project, Module module) {
            GradleModuleListener.updateBuildVariantView(project);
            for (ModuleListener listener : this.additionalListeners) {
                listener.moduleRemoved(project, module);
            }
        }

        private static void updateBuildVariantView(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$GradleModuleListener", "updateBuildVariantView"));
            }
            BuildVariantView.getInstance(project).updateContents();
        }

        void addModuleListener(@NotNull ModuleListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$GradleModuleListener", "addModuleListener"));
            }
            this.additionalListeners.add(listener);
        }
    }
}

