/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.AdtModuleImporter;
import com.android.tools.idea.gradle.project.GradleModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleImporter {
    private static final Key<ModuleImporter[]> KEY_IMPORTERS = new Key("com.android.tools.importers");
    private static final Key<ModuleImporter> KEY_CURRENT_IMPORTER = new Key("com.android.tools.currentImporter");
    private static final ModuleImporter NONE = new ModuleImporter(){

        @Override
        public boolean isStepVisible(ModuleWizardStep step) {
            return false;
        }

        @Override
        public List<? extends ModuleWizardStep> createWizardSteps() {
            return Collections.emptyList();
        }

        @Override
        public void importProjects(@Nullable Map<String, VirtualFile> projects) {
            LOG.error("Unsupported import kind");
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean canImport(VirtualFile importSource) {
            return false;
        }

        @Override
        public Set<ModuleToImport> findModules(VirtualFile importSource) {
            return Collections.emptySet();
        }
    };
    private static Logger LOG = Logger.getInstance(ModuleImporter.class);

    @NotNull
    public static synchronized ModuleImporter[] getAllImporters(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/project/ModuleImporter", "getAllImporters"));
        }
        ModuleImporter[] importers = (ModuleImporter[])context.getUserData(KEY_IMPORTERS);
        if (importers == null) {
            importers = ModuleImporter.createImporters(context);
        }
        if (importers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModuleImporter", "getAllImporters"));
        }
        return importers;
    }

    @NotNull
    private static ModuleImporter[] createImporters(WizardContext context) {
        ModuleImporter[] importers = new ModuleImporter[]{new AdtModuleImporter(context), new GradleModuleImporter(context)};
        context.putUserData(KEY_IMPORTERS, (Object)importers);
        if (importers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModuleImporter", "createImporters"));
        }
        return importers;
    }

    public static ModuleImporter[] getAllImporters(Project destinationProject) {
        return new ModuleImporter[]{new GradleModuleImporter(destinationProject)};
    }

    public static ModuleImporter getImporter(WizardContext context) {
        ModuleImporter importer = (ModuleImporter)context.getUserData(KEY_CURRENT_IMPORTER);
        if (importer != null) {
            return importer;
        }
        return NONE;
    }

    @NotNull
    public static ModuleImporter importerForLocation(WizardContext context, VirtualFile importSource) {
        for (ModuleImporter importer : ModuleImporter.getAllImporters(context)) {
            if (!importer.canImport(importSource)) continue;
            ModuleImporter moduleImporter = importer;
            if (moduleImporter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModuleImporter", "importerForLocation"));
            }
            return moduleImporter;
        }
        ModuleImporter moduleImporter = NONE;
        if (moduleImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModuleImporter", "importerForLocation"));
        }
        return moduleImporter;
    }

    public static void setImporter(WizardContext context, @Nullable ModuleImporter importer) {
        context.putUserData(KEY_CURRENT_IMPORTER, (Object)importer);
    }

    public abstract boolean isStepVisible(ModuleWizardStep var1);

    public abstract List<? extends ModuleWizardStep> createWizardSteps();

    public abstract void importProjects(@Nullable Map<String, VirtualFile> var1);

    public abstract boolean isValid();

    public abstract boolean canImport(VirtualFile var1);

    public abstract Set<ModuleToImport> findModules(VirtualFile var1) throws IOException;
}

