/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.StartParameter;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-(.*)-(.*)\\.jar");
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*-([^-]+)-([^.]+).zip");

    private GradleUtil() {
    }

    public static void clearStoredGradleJvmArgs(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "clearStoredGradleJvmArgs"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        final String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions("");
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String jvmArgs = existingJvmArgs.trim();
                    String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                    int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        try {
                            GradleProperties gradleProperties = new GradleProperties(project);
                            gradleProperties.setJvmArgs(jvmArgs);
                            gradleProperties.save();
                        }
                        catch (IOException e) {
                            String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                            LOG.info(err, (Throwable)e);
                            String cause = e.getMessage();
                            if (StringUtil.isNotEmpty((String)cause)) {
                                err = err + String.format("<br>\nCause: %1$s", cause);
                            }
                            AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                        }
                    } else {
                        String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                        AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                    }
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull FullRevision gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isSupportedGradleVersion"));
        }
        FullRevision supported = FullRevision.parseRevision((String)"2.2.1");
        return supported.compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject != null) {
            Icon icon = androidProject.isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
            }
            return icon;
        }
        Icon icon = Projects.isGradleProject(module.getProject()) ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        return icon;
    }

    @Nullable
    public static AndroidProject getAndroidProject(@NotNull Module module) {
        IdeaAndroidProject androidProject;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidProject"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidProject = facet.getIdeaAndroidProject()) != null) {
            return androidProject.getDelegate();
        }
        return null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradlePath"));
        }
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        return facet != null ? ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "isRootModuleWithNoSources"));
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<AndroidLibrary> getDirectLibraryDependencies(@NotNull Variant variant, @NotNull IdeaAndroidProject ideaAndroidProject) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        if (ideaAndroidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaAndroidProject", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(variant.getMainArtifact().getDependencies().getLibraries());
        BaseArtifact testArtifact = ideaAndroidProject.findSelectedTestArtifact(variant);
        if (testArtifact != null) {
            libraries.addAll(testArtifact.getDependencies().getLibraries());
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((String)":").omitEmptyStrings().split((CharSequence)gradlePath));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleProject() != null) {
            return gradleFacet.getGradleProject().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        return GradleUtil.getGradleBuildFile(moduleFilePath.getParentFile());
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(rootDir);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        File file = new File(rootDir, "build.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        return file;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFile"));
        }
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(rootDir);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        File file = new File(rootDir, "settings.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        return file;
    }

    @NotNull
    public static File getGradleWrapperPropertiesFilePath(@NotNull File projectRootDir) {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        File file = new File(projectRootDir, GRADLEW_PROPERTIES_PATH);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        return file;
    }

    public static boolean updateGradleDistributionUrl(@NotNull String gradleVersion, @NotNull File propertiesFile) throws IOException {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String gradleDistributionUrl = GradleUtil.getGradleDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(gradleDistributionUrl) || property.equals(GradleUtil.getGradleDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", gradleDistributionUrl);
        PropertiesUtil.savePropertiesToFile(properties, propertiesFile, null);
        return true;
    }

    @Nullable
    public static String getGradleWrapperVersion(@NotNull File propertiesFile) throws IOException {
        Matcher m;
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperVersion"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String url = properties.getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @NotNull
    private static String getGradleDistributionUrl(@NotNull String gradleVersion, boolean binOnly) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        return string;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleExecutionSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        Sdk jdk = IdeSdks.getJdk();
        if (jdk != null) {
            projectSettings.setGradleJvm(jdk.getName());
        }
        try {
            GradleExecutionSettings settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
            if (settings != null) {
                settings.setRemoteProcessIdleTtlInMs(-1L);
            }
            return settings;
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static File findWrapperPropertiesFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findWrapperPropertiesFile"));
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(baseDir);
        return wrapperPropertiesFile.isFile() ? wrapperPropertiesFile : null;
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleProjectSettings"));
        }
        GradleSettings settings = (GradleSettings)ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GRADLE_SYSTEM_ID);
        GradleSettings.MyState state = settings.getState();
        assert (state != null);
        Set allProjectsSettings = state.getLinkedExternalProjectsSettings();
        return GradleUtil.getFirstNotNull(allProjectsSettings);
    }

    @Nullable
    private static GradleProjectSettings getFirstNotNull(@Nullable Set<GradleProjectSettings> allProjectSettings) {
        if (allProjectSettings != null) {
            for (GradleProjectSettings settings : allProjectSettings) {
                if (settings == null) continue;
                return settings;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemons(boolean interactive) throws IOException {
        File gradleHome = GradleUtil.findAnyGradleHome(interactive);
        if (gradleHome == null) {
            throw new FileNotFoundException("Unable to find path to Gradle home directory");
        }
        File gradleExecutable = new File(gradleHome, FileUtil.join((String[])new String[]{"bin", SystemInfo.isWindows ? "gradle.bat" : "gradle"}));
        if (!gradleExecutable.isFile()) {
            throw new FileNotFoundException("Unable to find Gradle executable: " + gradleExecutable.getPath());
        }
        new ProcessBuilder(gradleExecutable.getPath(), "--stop").start();
    }

    @Nullable
    public static File findAnyGradleHome(boolean interactive) {
        File path;
        String lastUsedGradleHome = org.jetbrains.plugins.gradle.util.GradleUtil.getLastUsedGradleHome();
        if (!lastUsedGradleHome.isEmpty() && GradleUtil.isValidGradleHome(path = new File(lastUsedGradleHome))) {
            return path;
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            File gradleHome = GradleUtil.findGradleHome(project);
            if (gradleHome == null) continue;
            return gradleHome;
        }
        if (interactive) {
            ChooseGradleHomeDialog chooseGradleHomeDialog = new ChooseGradleHomeDialog();
            chooseGradleHomeDialog.setTitle("Choose Gradle Installation");
            String description = "A Gradle installation is necessary to stop all daemons.\nPlease select the home directory of a Gradle installation, otherwise the project won't be closed.";
            chooseGradleHomeDialog.setDescription(description);
            if (!chooseGradleHomeDialog.showAndGet()) {
                return null;
            }
            String enteredPath = chooseGradleHomeDialog.getEnteredGradleHomePath();
            File gradleHomePath = new File(enteredPath);
            if (GradleUtil.isValidGradleHome(gradleHomePath)) {
                chooseGradleHomeDialog.storeLastUsedGradleHomePath();
                return gradleHomePath;
            }
        }
        return null;
    }

    @Nullable
    private static File findGradleHome(@NotNull Project project) {
        WrapperExecutor wrapperExecutor;
        WrapperConfiguration configuration;
        File gradleHome;
        File path;
        String gradleHome2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findGradleHome"));
        }
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(project);
        if (settings != null && StringUtil.isNotEmpty((String)(gradleHome2 = settings.getGradleHome())) && GradleUtil.isValidGradleHome(path = new File(gradleHome2))) {
            return path;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null && (gradleHome = GradleUtil.getGradleHome(project, configuration = (wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile((File)wrapperPropertiesFile, (Appendable)new StringBuilder())).getConfiguration())) != null) {
            return gradleHome;
        }
        return null;
    }

    @Nullable
    private static File getGradleHome(@NotNull Project project, @NotNull WrapperConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleHome"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleHome"));
        }
        File systemHomePath = StartParameter.DEFAULT_GRADLE_USER_HOME;
        if ("PROJECT".equals(configuration.getDistributionBase())) {
            systemHomePath = new File(Projects.getBaseDirPath(project), ".gradle");
        }
        if (!systemHomePath.isDirectory()) {
            return null;
        }
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(systemHomePath).getDistribution(configuration);
        File distributionPath = localDistribution.getDistributionDir();
        if (distributionPath != null) {
            File[] children;
            for (File child : children = FileUtil.notNullize((File[])distributionPath.listFiles())) {
                if (!child.isDirectory() || !child.getName().startsWith("gradle-") || !GradleUtil.isValidGradleHome(child)) continue;
                return child;
            }
        }
        return null;
    }

    private static boolean isValidGradleHome(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradleHome"));
        }
        return path.isDirectory() && ((GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class)).isGradleSdkHome(path);
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        String string = FileUtil.join((String[])ArrayUtil.toStringArray(segments));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        return string;
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        return file;
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradlePath"));
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath, boolean checkProjectFolder) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "hasModule"));
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    public static void cleanUpPreferences(@NotNull ExtensionPoint<ConfigurableEP<Configurable>> preferences, @NotNull List<String> bundlesToRemove) {
        ConfigurableEP[] extensions;
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        if (bundlesToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundlesToRemove", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        ArrayList nonStudioExtensions = Lists.newArrayList();
        for (ConfigurableEP extension : extensions = (ConfigurableEP[])preferences.getExtensions()) {
            if (!bundlesToRemove.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        for (ConfigurableEP toRemove : nonStudioExtensions) {
            preferences.unregisterExtension((Object)toRemove);
        }
    }

    @Nullable
    public static FullRevision getGradleVersion(@NotNull Project project) {
        FullRevision revision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersion"));
        }
        String gradleVersion = Projects.getGradleVersionUsed(project);
        if (StringUtil.isNotEmpty((String)gradleVersion) && (revision = GradleUtil.parseRevision(GradleUtil.removeTimestampFromGradleVersion(gradleVersion))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
                if (wrapperPropertiesFile != null) {
                    try {
                        String wrapperVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
                        if (wrapperVersion != null) {
                            return GradleUtil.parseRevision(GradleUtil.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        LOG.info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return GradleUtil.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public static FullRevision getGradleVersion(@NotNull File gradleHomePath) {
        if (gradleHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleHomePath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersion"));
        }
        File libDirPath = new File(gradleHomePath, "lib");
        for (File child : FileUtil.notNullize((File[])libDirPath.listFiles())) {
            FullRevision version = GradleUtil.getGradleVersionFromJar(child);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static FullRevision getGradleVersionFromJar(@NotNull File libraryJarFile) {
        if (libraryJarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryJarFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersionFromJar"));
        }
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version = matcher.group(2);
            try {
                return PreciseRevision.parseRevision((String)GradleUtil.removeTimestampFromGradleVersion(version));
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("Unable to parse version '%1$s' (obtained from file '%2$s')", version, fileName));
            }
        }
        return null;
    }

    @NotNull
    private static String removeTimestampFromGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
        }
        int dashIndex = gradleVersion.indexOf(45);
        if (dashIndex != -1) {
            String string = gradleVersion.substring(0, dashIndex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
            }
            return string;
        }
        String string = gradleVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
        }
        return string;
    }

    public static boolean createGradleWrapper(@NotNull File projectDirPath) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        return GradleUtil.createGradleWrapper(projectDirPath, "2.4");
    }

    @VisibleForTesting
    public static boolean createGradleWrapper(@NotNull File projectDirPath, @NotNull String gradleVersion) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        File projectWrapperDirPath = new File(projectDirPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!projectWrapperDirPath.isDirectory()) {
            File wrapperSrcDirPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!wrapperSrcDirPath.exists()) {
                File root;
                Iterator<File> i$ = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (i$.hasNext() && !(wrapperSrcDirPath = new File(root = i$.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    wrapperSrcDirPath = null;
                }
            }
            if (wrapperSrcDirPath == null) {
                return false;
            }
            FileUtil.copyDirContent((File)wrapperSrcDirPath, (File)projectDirPath);
        }
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(projectDirPath);
        GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
        return true;
    }

    @Nullable
    public static FullRevision getResolvedAndroidGradleModelVersion(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getResolvedAndroidGradleModelVersion"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        final Ref modelVersionRef = new Ref();
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if ("build.gradle".equals(virtualFile.getName())) {
                    File fileToCheck = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    try {
                        String contents = FileUtil.loadFile((File)fileToCheck);
                        FullRevision version = GradleUtil.getResolvedAndroidGradleModelVersion(contents, project);
                        if (version != null) {
                            modelVersionRef.set((Object)version);
                            return false;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to read contents of " + fileToCheck.getPath());
                    }
                }
                return true;
            }
        });
        return (FullRevision)modelVersionRef.get();
    }

    @VisibleForTesting
    @Nullable
    static FullRevision getResolvedAndroidGradleModelVersion(@NotNull String fileContents, @Nullable Project project) {
        String revision;
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "getResolvedAndroidGradleModelVersion"));
        }
        GradleCoordinate found = GradleUtil.getPluginDefinition(fileContents, "com.android.tools.build:gradle:");
        if (found != null && StringUtil.isNotEmpty((String)(revision = GradleUtil.getAndroidGradleModelVersion(found, project)))) {
            return GradleUtil.parseRevision(revision);
        }
        return null;
    }

    @Nullable
    private static FullRevision parseRevision(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/gradle/util/GradleUtil", "parseRevision"));
        }
        try {
            return PreciseRevision.parseRevision((String)revision);
        }
        catch (NumberFormatException e) {
            LOG.info("Failed to parse revision '" + revision + "'", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static GradleCoordinate getPluginDefinition(@NotNull String fileContents, @NotNull String pluginName) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "getPluginDefinition"));
        }
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/android/tools/idea/gradle/util/GradleUtil", "getPluginDefinition"));
        }
        String definition = GradleUtil.findStringLiteral(pluginName, fileContents, new Function<Pair<String, GroovyLexer>, String>(){

            public String fun(Pair<String, GroovyLexer> pair) {
                return (String)pair.getFirst();
            }
        });
        return StringUtil.isNotEmpty((String)definition) ? GradleCoordinate.parseCoordinateString((String)definition) : null;
    }

    public static boolean updateGradleDependencyVersion(@NotNull Project project, final @NotNull Document buildFileDocument, final @NotNull String dependencyName, final @NotNull Computable<String> versionTask) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDependencyVersion"));
        }
        if (buildFileDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileDocument", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDependencyVersion"));
        }
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDependencyVersion"));
        }
        if (versionTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionTask", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDependencyVersion"));
        }
        String contents = buildFileDocument.getText();
        final TextRange range = GradleUtil.findStringLiteral(dependencyName, contents, new Function<Pair<String, GroovyLexer>, TextRange>(){

            public TextRange fun(Pair<String, GroovyLexer> pair) {
                GroovyLexer lexer = (GroovyLexer)pair.getSecond();
                return TextRange.create((int)(lexer.getTokenStart() + 1 + dependencyName.length()), (int)(lexer.getTokenEnd() - 1));
            }
        });
        if (range != null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    buildFileDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)versionTask.compute());
                }
            });
            return true;
        }
        return false;
    }

    @Nullable
    public static TextRange findDependency(@NotNull String dependency, @NotNull String contents) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/util/GradleUtil", "findDependency"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/gradle/util/GradleUtil", "findDependency"));
        }
        return GradleUtil.findStringLiteral(dependency, contents, new Function<Pair<String, GroovyLexer>, TextRange>(){

            public TextRange fun(Pair<String, GroovyLexer> pair) {
                GroovyLexer lexer = (GroovyLexer)pair.getSecond();
                return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
            }
        });
    }

    @Nullable
    private static <T> T findStringLiteral(@NotNull String textToSearchPrefix, @NotNull String fileContents, @NotNull Function<Pair<String, GroovyLexer>, T> consumer) {
        if (textToSearchPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToSearchPrefix", "com/android/tools/idea/gradle/util/GradleUtil", "findStringLiteral"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "findStringLiteral"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/util/GradleUtil", "findStringLiteral"));
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(textToSearchPrefix)) {
                return (T)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    @Nullable
    public static String getPluginDefinitionString(@NotNull String fileContents, @NotNull String pluginName) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "getPluginDefinitionString"));
        }
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/android/tools/idea/gradle/util/GradleUtil", "getPluginDefinitionString"));
        }
        return GradleUtil.forPluginDefinition(fileContents, pluginName, new Function<Pair<String, GroovyLexer>, String>(){

            public String fun(Pair<String, GroovyLexer> pair) {
                return (String)pair.getFirst();
            }
        });
    }

    @Nullable
    public static <T> T forPluginDefinition(@NotNull String fileContents, @NotNull String pluginName, @NotNull Function<Pair<String, GroovyLexer>, T> consumer) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "forPluginDefinition"));
        }
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/android/tools/idea/gradle/util/GradleUtil", "forPluginDefinition"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/util/GradleUtil", "forPluginDefinition"));
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(pluginName)) {
                return (T)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    @Nullable
    private static String getAndroidGradleModelVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        GradleCoordinate latest;
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidGradleModelVersion"));
        }
        String revision = coordinate.getFullRevision();
        if (StringUtil.isNotEmpty((String)revision)) {
            if (!coordinate.acceptsGreaterRevisions()) {
                return revision;
            }
            int major = coordinate.getMajorVersion();
            int minor = coordinate.getMinorVersion();
            if (coordinate.getMicroVersion() == -1 && major >= 0 && minor > 0) {
                return major + "." + minor + "." + 0;
            }
        }
        return (latest = GradleUtil.findLatestVersionInGradleCache(coordinate, null, project)) != null ? latest.getFullRevision() : null;
    }

    @Nullable
    public static GradleCoordinate findLatestVersionInGradleCache(@NotNull GradleCoordinate original, @Nullable String filter, @Nullable Project project) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            GradleCoordinate version = GradleUtil.findLatestVersionInGradleCache(gradleServicePath, original, filter);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static GradleCoordinate findLatestVersionInGradleCache(@NotNull File gradleServicePath, @NotNull GradleCoordinate original, @Nullable String filter) {
        if (gradleServicePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleServicePath", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        File gradleCache = new File(gradleServicePath, "caches");
        if (gradleCache.exists()) {
            ArrayList coordinates = Lists.newArrayList();
            String groupId = original.getGroupId();
            String artifactId = original.getArtifactId();
            for (File moduleDir : FileUtil.notNullize((File[])gradleCache.listFiles())) {
                if (!moduleDir.getName().startsWith("modules-") || !moduleDir.isDirectory()) continue;
                for (File metadataDir : FileUtil.notNullize((File[])moduleDir.listFiles())) {
                    File versionDir;
                    if (!metadataDir.getName().startsWith("metadata-") || !metadataDir.isDirectory() || !(versionDir = new File(metadataDir, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                    for (File version : FileUtil.notNullize((File[])versionDir.listFiles())) {
                        GradleCoordinate found;
                        String name = version.getName();
                        if (filter != null && !name.startsWith(filter) || name.isEmpty() || !Character.isDigit(name.charAt(0)) || (found = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + name))) == null) continue;
                        coordinates.add(found);
                    }
                }
            }
            if (!coordinates.isEmpty()) {
                Collections.sort(coordinates, GradleCoordinate.COMPARE_PLUS_LOWER);
                return (GradleCoordinate)coordinates.get(coordinates.size() - 1);
            }
        }
        return null;
    }

    public static void addLocalMavenRepoInitScriptCommandLineOption(@NotNull List<String> args) {
        File repoPath;
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        if ((AndroidStudioSpecificInitializer.isAndroidStudio() || ApplicationManager.getApplication().isUnitTestMode()) && (repoPath = EmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPath()) != null && repoPath.isDirectory()) {
            GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args, repoPath);
        }
    }

    @VisibleForTesting
    @Nullable
    static File addLocalMavenRepoInitScriptCommandLineOption(@NotNull List<String> args, @NotNull File repoPath) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        if (repoPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPath", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        try {
            File file = FileUtil.createTempFile((String)"asLocalRepo", (String)".gradle");
            file.deleteOnExit();
            String contents = "allprojects {\n  buildscript {\n    repositories {\n      maven { url '" + GradleImport.escapeGroovyStringLiteral(repoPath.getPath()) + "'}\n" + "    }\n" + "  }\n" + "}\n";
            FileUtil.writeToFile((File)file, (String)contents);
            ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", file.getAbsolutePath()});
            return file;
        }
        catch (IOException e) {
            LOG.warn("Failed to set up 'local repo' Gradle init script", (Throwable)e);
            return null;
        }
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        File wrapperPropertiesFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "attemptToUseEmbeddedGradle"));
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio() && (wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = PropertiesUtil.getProperties(wrapperPropertiesFile);
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + wrapperPropertiesFile.getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleUtil.isWrapperInGradleCache(project, gradleVersion) && (embeddedGradlePath = EmbeddedDistributionPaths.findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isCompatibleWithEmbeddedGradleVersion"));
        }
        return gradleVersion.equals("2.2.1") || gradleVersion.equals("2.4");
    }

    private static boolean isWrapperInGradleCache(@NotNull Project project, @NotNull String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "isWrapperInGradleCache"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isWrapperInGradleCache"));
        }
        String distFolderDirName = "gradle-" + gradleVersion;
        String wrapperDirNamePrefix = distFolderDirName + "-";
        String[] wrapperDirNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            for (String wrapperDirName : wrapperDirNames) {
                File wrapperDirPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperDirName}));
                if (!wrapperDirPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperDirPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderDirName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> getGradleServicePaths(@Nullable Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet paths = Sets.newLinkedHashSet();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths.add(file);
        }
        if ((path = new File(SystemProperties.getUserHome(), ".gradle")).isDirectory()) {
            paths.add(path);
        }
        LinkedHashSet linkedHashSet = paths;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleServicePaths"));
        }
        return linkedHashSet;
    }

    public static boolean dependsOn(@NonNull IdeaAndroidProject project, @NonNull String artifact) {
        Dependencies dependencies = project.getSelectedVariant().getMainArtifact().getDependencies();
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    private static boolean dependsOn(@NonNull Dependencies dependencies, @NonNull String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(@NonNull AndroidLibrary library, @NonNull String artifact, boolean transitively) {
        String s;
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.equals(s = resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return true;
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                if (!GradleUtil.dependsOn(dependency, artifact, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        if (causeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "causeClass", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    @Nullable
    public static DataNode<ProjectData> getCachedProjectData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getCachedProjectData"));
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(project, GRADLE_SYSTEM_ID, Projects.getBaseDirPath(project).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public static boolean hasLayoutRenderingIssue(@NotNull AndroidProject model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/util/GradleUtil", "hasLayoutRenderingIssue"));
        }
        String modelVersion = model.getModelVersion();
        return modelVersion.startsWith("1.2.0") || modelVersion.equals("1.2.1") || modelVersion.equals("1.2.2");
    }
}

