/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.GradleBuildListener;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.AarResourceClassGenerator;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.Map;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarResourceClassRegistry
implements ProjectComponent {
    private final Map<String, AarResourceClassGenerator> myGeneratorMap = Maps.newHashMap();
    private final Project myProject;
    private GradleBuildListener myBuildCompleteListener;

    public AarResourceClassRegistry(Project project) {
        this.myProject = project;
    }

    public void addLibrary(AppResourceRepository appResources, File aarDir) {
        String pkg;
        FileResourceRepository repository;
        String path = aarDir.getPath();
        if ((path.endsWith(".aar") || path.contains("exploded-aar")) && (repository = appResources.findRepositoryFor(aarDir)) != null && (pkg = AarResourceClassRegistry.getAarPackage(aarDir)) != null) {
            AarResourceClassGenerator generator = AarResourceClassGenerator.create(appResources, repository);
            this.myGeneratorMap.put(pkg, generator);
        }
    }

    @Nullable
    private static String getAarPackage(@NotNull File aarDir) {
        if (aarDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aarDir", "com/android/tools/idea/rendering/AarResourceClassRegistry", "getAarPackage"));
        }
        File manifest = new File(aarDir, "AndroidManifest.xml");
        if (manifest.exists()) {
            try {
                return AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifest));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String name) {
        String pkg;
        AarResourceClassGenerator generator;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/AarResourceClassRegistry", "findClassDefinition"));
        }
        int index = name.lastIndexOf(46);
        if (index != -1 && name.charAt(index + 1) == 'R' && (index == name.length() - 2 || name.charAt(index + 2) == '$') && index > 1 && (generator = this.myGeneratorMap.get(pkg = name.substring(0, index))) != null) {
            this.registerSyncListenerIfNecessary();
            return generator.generate(name);
        }
        return null;
    }

    private void registerSyncListenerIfNecessary() {
        if (this.myBuildCompleteListener != null) {
            return;
        }
        this.myBuildCompleteListener = new GradleBuildListener(){

            @Override
            public void buildFinished(@NotNull Project builtProject, @Nullable BuildMode mode) {
                if (builtProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtProject", "com/android/tools/idea/rendering/AarResourceClassRegistry$1", "buildFinished"));
                }
                if (mode == null || builtProject != AarResourceClassRegistry.this.myProject) {
                    return;
                }
                switch (mode) {
                    case CLEAN: 
                    case ASSEMBLE: 
                    case COMPILE_JAVA: {
                        ModuleClassLoader.clearCache();
                    }
                }
            }
        };
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(PostProjectBuildTasksExecutor.GRADLE_BUILD_TOPIC, (Object)this.myBuildCompleteListener);
    }

    public static AarResourceClassRegistry get(Project project) {
        return (AarResourceClassRegistry)project.getComponent(AarResourceClassRegistry.class);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        String string = AarResourceClassRegistry.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AarResourceClassRegistry", "getComponentName"));
        }
        return string;
    }
}

