/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import icons.AndroidIcons;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FlagManager {
    private static final FlagManager ourInstance = new FlagManager();
    @NotNull
    private final Map<String, Icon> myImageMap = Maps.newHashMap();

    @NotNull
    public static FlagManager get() {
        FlagManager flagManager = ourInstance;
        if (flagManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "get"));
        }
        return flagManager;
    }

    private FlagManager() {
    }

    @Nullable
    public Icon getFlag(@Nullable String language, @Nullable String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            assert (language != null);
            if (language.equals("ca")) {
                return this.getIcon("catalonia");
            }
            if (language.equals("gd")) {
                return this.getIcon("scotland");
            }
            if (language.equals("cy")) {
                return this.getIcon("wales");
            }
            region = LocaleManager.getLanguageRegion((String)language);
        }
        if (region == null || region.isEmpty() || region.length() == 3) {
            return null;
        }
        return this.getIcon(region);
    }

    @Nullable
    public Icon getFlag(@NonNull FolderConfiguration configuration) {
        return this.getFlag(configuration.getLocaleQualifier());
    }

    @Nullable
    public Icon getFlag(@Nullable LocaleQualifier locale) {
        if (locale == null) {
            return null;
        }
        String languageCode = locale.getLanguage();
        String regionCode = locale.getRegion();
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    @Nullable
    public Icon getFlagForFolderName(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/rendering/FlagManager", "getFlagForFolderName"));
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)folder);
        if (configuration != null) {
            return FlagManager.get().getFlag(configuration);
        }
        return null;
    }

    @Nullable
    public Icon getFlag(@NotNull String region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/android/tools/idea/rendering/FlagManager", "getFlag"));
        }
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    @Nullable
    private Icon getIcon(@NotNull String base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/android/tools/idea/rendering/FlagManager", "getIcon"));
        }
        Icon flagImage = this.myImageMap.get(base);
        if (flagImage == null) {
            if (this.myImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = base.toLowerCase(Locale.US) + ".png";
            try {
                flagImage = IconLoader.findIcon((String)("/icons/flags/" + flagFileName), AndroidIcons.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (flagImage == null) {
                flagImage = AndroidIcons.EmptyFlag;
            }
            this.myImageMap.put(base, flagImage);
        }
        return flagImage;
    }

    @NotNull
    public ListCellRenderer getLanguageCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getLanguageNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag((String)value, null));
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getLanguageCodeCellRenderer"));
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public ListCellRenderer getRegionCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getRegionNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag(null, (String)value));
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getRegionCodeCellRenderer"));
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public static Function<Object, String> getLanguageNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value) {
                String languageCode = (String)value;
                if (languageCode.equals("__")) {
                    return "Any Language";
                }
                String languageName = LocaleManager.getLanguageName((String)languageCode);
                if (languageName != null && languageName.length() > 30) {
                    languageName = languageName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", languageCode, languageName);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getLanguageNameMapper"));
        }
        return function;
    }

    @NotNull
    public static Function<Object, String> getRegionNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value) {
                String regionCode = (String)value;
                if (regionCode.equals("__")) {
                    return "Any Region";
                }
                String regionName = LocaleManager.getRegionName((String)regionCode);
                if (regionName != null && regionName.length() > 30) {
                    regionName = regionName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", regionCode, regionName);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getRegionNameMapper"));
        }
        return function;
    }
}

