/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    protected List<? extends LocalResourceRepository> myChildren;
    private long[] myModificationCounts;
    private Map<ResourceType, ListMultimap<String, ResourceItem>> myItems;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myCachedTypeMaps;
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    private long myDataBindingResourceFilesModificationCount;

    MultiResourceRepository(@NotNull String displayName, @NotNull List<? extends LocalResourceRepository> children) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/rendering/MultiResourceRepository", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/MultiResourceRepository", "<init>"));
        }
        super(displayName);
        this.myItems = Maps.newEnumMap(ResourceType.class);
        this.myCachedTypeMaps = Maps.newEnumMap(ResourceType.class);
        this.myDataBindingResourceFiles = Maps.newHashMap();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
        this.setChildren(children);
    }

    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        int i;
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/MultiResourceRepository", "setChildren"));
        }
        if (this.myChildren != null) {
            for (i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                resources.removeParent(this);
            }
            if (this.myChildren.size() == 1) {
                this.myGeneration = Math.max(this.myChildren.get(0).getModificationCount(), this.myGeneration);
            }
        }
        this.myChildren = children;
        this.myModificationCounts = new long[children.size()];
        if (children.size() == 1) {
            LocalResourceRepository child = children.get(0);
            long modCount = Math.max(child.getModificationCount(), this.myGeneration);
            child.myGeneration = modCount + 1L;
            this.myGeneration = modCount;
        }
        for (i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.addParent(this);
            this.myModificationCounts[i] = resources.getModificationCount();
        }
        ++this.myGeneration;
        this.clearCache();
        this.invalidateItemCaches(new ResourceType[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        this.myItems = null;
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            this.myCachedTypeMaps.clear();
        }
    }

    public List<? extends LocalResourceRepository> getChildren() {
        return this.myChildren;
    }

    @Override
    public long getModificationCount() {
        if (this.myChildren.size() == 1) {
            return this.myChildren.get(0).getModificationCount();
        }
        boolean changed = false;
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            long rev = resources.getModificationCount();
            if (rev == this.myModificationCounts[i]) continue;
            this.myModificationCounts[i] = rev;
            changed = true;
        }
        if (changed) {
            ++this.myGeneration;
        }
        return this.myGeneration;
    }

    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            DataBindingInfo info = localResourceRepository.getDataBindingInfoForLayout(layoutName);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MultiResourceRepository", "getDataBindingResourceFiles"));
            }
            return map;
        }
        HashMap selected = Maps.newHashMap();
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            Map<String, DataBindingInfo> childFiles = localResourceRepository.getDataBindingResourceFiles();
            if (childFiles == null) continue;
            selected.putAll(childFiles);
        }
        this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MultiResourceRepository", "getDataBindingResourceFiles"));
        }
        return map;
    }

    @NonNull
    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.myItems == null) {
            if (this.myChildren.size() == 1) {
                this.myItems = this.myChildren.get(0).getItems();
            } else {
                EnumMap map = Maps.newEnumMap(ResourceType.class);
                for (ResourceType type : ResourceType.values()) {
                    map.put(type, this.getMap(type, false));
                }
                this.myItems = map;
            }
        }
        return this.myItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            ListMultimap<String, ResourceItem> map = this.myCachedTypeMaps.get(type);
            if (map != null) {
                return map;
            }
        }
        if (this.myChildren.size() == 1) {
            LocalResourceRepository child = this.myChildren.get(0);
            if (child instanceof MultiResourceRepository) {
                return ((MultiResourceRepository)child).getMap(type);
            }
            return (ListMultimap)child.getItems().get(type);
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            Map items = resources.getItems();
            ListMultimap m = (ListMultimap)items.get(type);
            if (m == null) continue;
            for (ResourceItem item : m.values()) {
                String name = item.getName();
                if (map.containsKey((Object)name) && item.getType() != ResourceType.ID) {
                    String qualifiers = item.getQualifiers();
                    boolean contains = false;
                    List list = map.get((Object)name);
                    assert (list != null);
                    for (ResourceItem existing : list) {
                        if (!qualifiers.equals(existing.getQualifiers())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    map.put((Object)name, (Object)item);
                    continue;
                }
                map.put((Object)name, (Object)item);
            }
        }
        MultiResourceRepository multiResourceRepository2 = this;
        synchronized (multiResourceRepository2) {
            this.myCachedTypeMaps.put(type, (ListMultimap<String, ResourceItem>)map);
        }
        return map;
    }

    @NonNull
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type) {
        return super.getMap(type);
    }

    @NonNull
    public Map<ResourceType, ListMultimap<String, ResourceItem>> getItems() {
        return this.getMap();
    }

    @Override
    public void dispose() {
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.removeParent(this);
            resources.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, ResourceType ... types) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/rendering/MultiResourceRepository", "invalidateCache"));
        }
        assert (this.myChildren.contains((Object)repository)) : repository;
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            if (types == null || types.length == 0) {
                this.myCachedTypeMaps.clear();
            } else {
                for (ResourceType type : types) {
                    this.myCachedTypeMaps.remove(type);
                }
            }
        }
        this.myItems = null;
        ++this.myGeneration;
        this.invalidateItemCaches(types);
    }

    @Override
    public boolean isScanPending(@NonNull PsiFile psiFile) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            if (!resources.isScanPending(psiFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sync() {
        super.sync();
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.sync();
        }
    }

    int getChildCount() {
        return this.myChildren.size();
    }
}

