/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class RDotTxtParser {
    private static final String INT_ID = "int id ";
    private static final int INT_ID_LEN = "int id ".length();
    private static final Logger LOG = Logger.getInstance(RDotTxtParser.class);

    RDotTxtParser() {
    }

    static Collection<String> parseFile(final File rFile) {
        try {
            return (Collection)Files.readLines((File)rFile, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Collection<String>>(){
                Collection<String> idNames = new ArrayList<String>(32);

                public boolean processLine(@NotNull String line) throws IOException {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/rendering/RDotTxtParser$1", "processLine"));
                    }
                    if (!line.startsWith(RDotTxtParser.INT_ID)) {
                        return true;
                    }
                    int i = line.indexOf(32, INT_ID_LEN);
                    assert (i != -1) : "File not in expected format: " + rFile.getPath() + "\n" + "Expected the ids to be in the format int id <name> <number>";
                    this.idNames.add(line.substring(INT_ID_LEN, i));
                    return true;
                }

                public Collection<String> getResult() {
                    return this.idNames;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Unable to read file: " + rFile.getPath(), (Throwable)e);
            return null;
        }
    }
}

