/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidBundle;

public class RefreshRenderAction
extends AnAction {
    private final RenderContext myContext;

    public RefreshRenderAction(RenderContext context) {
        super(AndroidBundle.message("android.layout.preview.refresh.action.text", new Object[0]), null, AllIcons.Actions.Refresh);
        this.myContext = context;
    }

    public void actionPerformed(AnActionEvent e) {
        RefreshRenderAction.clearCache(this.myContext);
    }

    public static void clearCache(RenderContext context) {
        ModuleClassLoader.clearCache();
        Configuration configuration = context.getConfiguration();
        if (configuration != null) {
            AndroidFacet facet;
            AndroidTargetData targetData;
            IAndroidTarget target = configuration.getTarget();
            Module module = configuration.getModule();
            if (target != null && module != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
                targetData.clearLayoutBitmapCache(module);
            }
            if ((facet = AndroidFacet.getInstance(configuration.getModule())) != null) {
                facet.refreshResources();
            }
            configuration.updated(254);
        }
        context.requestRender();
    }
}

