/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudTestingConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConfigurationProvider {
    private static final String EXTERNAL_ENABLE_FLAG = "enable.google.cloud.testing.plugin";
    public static final ExtensionPointName<CloudConfigurationProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.run.cloudConfigurationProvider");

    @NotNull
    public abstract List<? extends CloudConfiguration> getCloudConfigurations(@NotNull AndroidFacet var1, @NotNull CloudConfiguration.Kind var2);

    @Nullable
    public abstract CloudConfiguration openMatrixConfigurationDialog(@NotNull AndroidFacet var1, @Nullable CloudConfiguration var2, @NotNull CloudConfiguration.Kind var3);

    @Nullable
    public abstract String openCloudProjectConfigurationDialog(@NotNull Project var1, @Nullable String var2);

    public abstract void launchCloudDevice(int var1, @NotNull String var2, @NotNull AndroidFacet var3);

    @NotNull
    public abstract ExecutionResult executeCloudMatrixTests(int var1, @NotNull String var2, @NotNull AndroidRunningState var3, @NotNull Executor var4) throws ExecutionException;

    public static boolean isEnabled() {
        return Boolean.getBoolean(EXTERNAL_ENABLE_FLAG) || CloudTestingConfigurable.getPersistedEnableProperty();
    }

    public static boolean canEnable() {
        CloudConfigurationProvider provider = CloudConfigurationProvider.getExtension();
        if (provider != null) {
            return provider.canBeEnabled();
        }
        return false;
    }

    protected abstract boolean canBeEnabled();

    @NotNull
    public abstract Collection<IDevice> getLaunchingCloudDevices();

    @Nullable
    public abstract Icon getCloudDeviceIcon();

    @Nullable
    public abstract String getCloudDeviceConfiguration(IDevice var1);

    @Nullable
    public static CloudConfigurationProvider getCloudConfigurationProvider() {
        if (!CloudConfigurationProvider.isEnabled()) {
            return null;
        }
        return CloudConfigurationProvider.getExtension();
    }

    @Nullable
    private static CloudConfigurationProvider getExtension() {
        CloudConfigurationProvider[] extensions = (CloudConfigurationProvider[])EP_NAME.getExtensions();
        if (extensions.length > 0) {
            return extensions[0];
        }
        return null;
    }
}

