/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkPath, boolean includePathInMessage) {
        ValidationResult validationResult = SdkPaths.validatedSdkPath(sdkPath, "SDK", true, includePathInMessage);
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validateAndroidSdk"));
        }
        return validationResult;
    }

    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        if (!validationResult.success) {
            ValidationResult validationResult2 = validationResult;
            if (validationResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validateAndroidNdk"));
            }
            return validationResult2;
        }
        File toolchainsDirPath = new File(ndkPath, "toolchains");
        if (!toolchainsDirPath.isDirectory()) {
            String message = includePathInMessage ? String.format("The NDK at\n'%1$s'\ndoes not contain any toolchains.", ndkPath.getPath()) : "NDK does not contain any toolchains.";
            ValidationResult validationResult3 = ValidationResult.error(message);
            if (validationResult3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validateAndroidNdk"));
            }
            return validationResult3;
        }
        ValidationResult validationResult4 = ValidationResult.SUCCESS;
        if (validationResult4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validateAndroidNdk"));
        }
        return validationResult4;
    }

    @NotNull
    private static ValidationResult validatedSdkPath(@Nullable File sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "com/android/tools/idea/sdk/SdkPaths", "validatedSdkPath"));
        }
        if (sdkPath == null) {
            ValidationResult validationResult = ValidationResult.error("");
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validatedSdkPath"));
            }
            return validationResult;
        }
        String cause = null;
        if (!sdkPath.isDirectory()) {
            cause = "does not belong to a directory.";
        } else if (!sdkPath.canRead()) {
            cause = "is not readable.";
        } else if (checkForWritable && !sdkPath.canWrite()) {
            cause = "is not writable.";
        }
        if (StringUtil.isNotEmpty((String)cause)) {
            String message = includePathInMessage ? String.format("The path\n'%1$s'\n%2$s", sdkPath.getPath(), cause) : String.format("The path %1$s", cause);
            ValidationResult validationResult = ValidationResult.error(message);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validatedSdkPath"));
            }
            return validationResult;
        }
        File platformsDirPath = new File(sdkPath, "platforms");
        if (!platformsDirPath.isDirectory()) {
            String message = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath.getPath()) : String.format("%1$s does not contain any platforms.", sdkName);
            ValidationResult validationResult = ValidationResult.error(message);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validatedSdkPath"));
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.SUCCESS;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths", "validatedSdkPath"));
        }
        return validationResult;
    }

    public static class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        static ValidationResult error(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/sdk/SdkPaths$ValidationResult", "error"));
            }
            ValidationResult validationResult = new ValidationResult(false, message);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkPaths$ValidationResult", "error"));
            }
            return validationResult;
        }

        private ValidationResult(boolean success, @Nullable String message) {
            this.success = success;
            this.message = message;
        }
    }
}

