/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.GuardedBy;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.RemoteSdk;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.Semaphore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.sdk.AndroidSdkData;

public class SdkState {
    public static final long DEFAULT_EXPIRATION_PERIOD_MS = TimeUnit.DAYS.toMillis(1L);
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.sdk.SdkState");
    @GuardedBy(value="sSdkStates")
    private static final Set<SoftReference<SdkState>> sSdkStates = new HashSet<SoftReference<SdkState>>();
    @Nullable
    private final AndroidSdkData mySdkData;
    private final RemoteSdk myRemoteSdk;
    private SdkPackages myPackages = new SdkPackages();
    private long myLastRefreshMs;
    private LoadTask myTask;
    private final Object myTaskLock = new Object();

    private SdkState(@Nullable AndroidSdkData sdkData) {
        this.mySdkData = sdkData;
        if (this.mySdkData == null) {
            this.myPackages = new SdkPackages();
        }
        this.myRemoteSdk = new RemoteSdk(new LogWrapper(Logger.getInstance(SdkState.class)));
    }

    @NonNull
    public RemoteSdk getRemoteSdk() {
        return this.myRemoteSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static SdkState getInstance(@Nullable AndroidSdkData sdkData) {
        Set<SoftReference<SdkState>> set = sSdkStates;
        synchronized (set) {
            Iterator<SoftReference<SdkState>> it = sSdkStates.iterator();
            while (it.hasNext()) {
                SoftReference<SdkState> ref = it.next();
                SdkState s = (SdkState)ref.get();
                if (s == null) {
                    it.remove();
                    continue;
                }
                if (s.mySdkData != sdkData) continue;
                return s;
            }
            SdkState s = new SdkState(sdkData);
            sSdkStates.add((SoftReference<SdkState>)new SoftReference((Object)s));
            return s;
        }
    }

    @Nullable
    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    @NonNull
    public SdkPackages getPackages() {
        return this.myPackages;
    }

    public boolean loadAsync(long timeoutMs, boolean canBeCancelled, @Nullable Runnable onLocalComplete, @Nullable Runnable onSuccess, @Nullable Runnable onError, boolean forceRefresh) {
        return this.load(timeoutMs, canBeCancelled, SdkState.createList(onLocalComplete), SdkState.createList(onSuccess), SdkState.createList(onError), forceRefresh, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(long timeoutMs, boolean canBeCancelled, @NonNull List<Runnable> onLocalComplete, @NonNull List<Runnable> onSuccess, @NonNull List<Runnable> onError, boolean forceRefresh, boolean sync) {
        if (!forceRefresh && System.currentTimeMillis() - this.myLastRefreshMs < timeoutMs) {
            for (Runnable localComplete : onLocalComplete) {
                localComplete.run();
            }
            for (Runnable success : onSuccess) {
                success.run();
            }
            return false;
        }
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myTask != null) {
                this.myTask.addCallbacks(onLocalComplete, onSuccess, onError);
                return false;
            }
            this.myTask = new LoadTask(canBeCancelled, onLocalComplete, onSuccess, onError, forceRefresh, sync);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            this.myTask.run((ProgressIndicator)new EmptyProgressIndicator());
            return true;
        }
        ProgressManager.getInstance().run((Task)this.myTask);
        return true;
    }

    public boolean loadSynchronously(long timeoutMs, boolean canBeCancelled, @Nullable Runnable onLocalComplete, @Nullable Runnable onSuccess, final @Nullable Runnable onError, boolean forceRefresh) {
        final Semaphore completed = new Semaphore();
        completed.down();
        Runnable complete = new Runnable(){

            @Override
            public void run() {
                completed.up();
            }
        };
        List<Runnable> onLocalCompletes = SdkState.createList(onLocalComplete);
        List<Runnable> onSuccesses = SdkState.createList(onSuccess);
        List<Runnable> onErrors = SdkState.createList(onError);
        onSuccesses.add(complete);
        onErrors.add(complete);
        boolean result = this.load(timeoutMs, canBeCancelled, onLocalCompletes, onSuccesses, onErrors, forceRefresh, true);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            if (result) {
                return result;
            }
            try {
                completed.waitForUnsafe();
            }
            catch (InterruptedException e) {
                onError.run();
                return false;
            }
            return true;
        }
        ProgressManager pm = ProgressManager.getInstance();
        ProgressIndicator indicator = pm.getProgressIndicator();
        indicator = indicator == null ? new ProgressWindow(false, false, null) : indicator;
        pm.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                boolean success = false;
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                try {
                    completed.waitForUnsafe();
                    success = true;
                }
                catch (InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
                if (!success && onError != null) {
                    onError.run();
                }
            }
        }, indicator);
        return result;
    }

    @NonNull
    private static List<Runnable> createList(@Nullable Runnable r) {
        if (r == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Runnable[]{r});
    }

    private class LoadTask
    extends Task.ConditionalModal {
        private final List<Runnable> myOnSuccesses;
        private final List<Runnable> myOnErrors;
        private final List<Runnable> myOnLocalCompletes;
        private final boolean myForceRefresh;
        private ProgressWindow myProgress;

        public LoadTask(@NonNull boolean canBeCancelled, @NonNull List<Runnable> onLocalComplete, @NonNull List<Runnable> onSuccess, List<Runnable> onError, boolean forceRefresh, boolean modal) {
            super(null, "Loading Android SDK", canBeCancelled, modal ? PerformInBackgroundOption.DEAF : PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myOnSuccesses = Lists.newArrayList();
            this.myOnErrors = Lists.newArrayList();
            this.myOnLocalCompletes = Lists.newArrayList();
            this.addCallbacks(onLocalComplete, onSuccess, onError);
            this.myForceRefresh = forceRefresh;
        }

        public void setProgress(ProgressWindow progress) {
            assert (this.myProgress == null);
            this.myProgress = progress;
        }

        public void addCallbacks(@NonNull List<Runnable> onLocalComplete, @NonNull List<Runnable> onSuccess, @NonNull List<Runnable> onError) {
            this.myOnLocalCompletes.addAll(onLocalComplete);
            this.myOnSuccesses.addAll(onSuccess);
            this.myOnErrors.addAll(onError);
        }

        public ProgressWindow getProgress() {
            return this.myProgress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NonNull ProgressIndicator indicator) {
            boolean success = false;
            try {
                IndicatorLogger logger = new IndicatorLogger(indicator);
                SdkPackages packages = new SdkPackages();
                if (SdkState.this.mySdkData != null) {
                    indicator.setText("Loading local SDK...");
                    indicator.setText2("");
                    if (this.myForceRefresh) {
                        SdkState.this.mySdkData.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
                    }
                    packages.setLocalPkgInfos(SdkState.this.mySdkData.getLocalSdk().getPkgsInfos(PkgType.PKG_ALL));
                    SdkState.this.myLastRefreshMs = 0L;
                    SdkState.this.myPackages = packages;
                    indicator.setFraction(0.25);
                }
                if (indicator.isCanceled()) {
                    return;
                }
                Object object = SdkState.this.myTaskLock;
                synchronized (object) {
                    for (Runnable onLocalComplete : this.myOnLocalCompletes) {
                        onLocalComplete.run();
                    }
                    this.myOnLocalCompletes.clear();
                }
                indicator.setText("Find SDK Repository...");
                indicator.setText2("");
                SdkSources sources = SdkState.this.myRemoteSdk.fetchSources(this.myForceRefresh ? 0L : 86400000L, logger);
                indicator.setFraction(0.5);
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText("Check SDK Repository...");
                indicator.setText2("");
                Multimap<PkgType, RemotePkgInfo> remotes = SdkState.this.myRemoteSdk.fetch(sources, logger);
                indicator.setText("Compute SDK updates...");
                indicator.setFraction(0.75);
                packages.setRemotePkgInfos(remotes);
                SdkState.this.myPackages = packages;
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText2("");
                indicator.setFraction(1.0);
                if (indicator.isCanceled()) {
                    return;
                }
                success = true;
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
            }
            finally {
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                Object object = SdkState.this.myTaskLock;
                synchronized (object) {
                    SdkState.this.myTask = null;
                    if (success) {
                        for (Runnable onLocalComplete : this.myOnLocalCompletes) {
                            onLocalComplete.run();
                        }
                        for (Runnable onSuccess : this.myOnSuccesses) {
                            onSuccess.run();
                        }
                    } else {
                        for (Runnable onError : this.myOnErrors) {
                            onError.run();
                        }
                    }
                }
            }
        }
    }

    private static class IndicatorLogger
    implements ILogger {
        @NonNull
        private final ProgressIndicator myIndicator;

        public IndicatorLogger(@NonNull ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
            if (msgFormat == null && t != null) {
                this.myIndicator.setText2(t.toString());
            } else if (msgFormat != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
        }

        public void warning(@NonNull String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void info(@NonNull String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void verbose(@NonNull String msgFormat, Object ... args) {
        }
    }
}

